/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MyStoreBean.java 3030 2009-01-27 14:43:49Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.samples;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class MyStoreBean implements SessionBean {

	private static final long serialVersionUID = -5266558404062260967L;

	private Map products;

	private Map cart;

	public void ejbCreate() throws EJBException {
		products = new HashMap(6);
		products.put("Christmas CDs collection", new Integer(20));
		products.put("Collector DVD collection", new Integer(25));
		products.put("Forgetting Sarah DVD", new Integer(10));
		products.put("My favorite Elvis songs", new Integer(10));
		products.put("New York Fair 1939", new Integer(5));

		cart = new HashMap();
	}

	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

    public void setSessionContext(final SessionContext sc) throws EJBException, RemoteException {
        // Nothing
    }

	public Map getProducts() {
		return products;
	}

	public void addItem(String item) {
		if (item != null && products.containsKey(item)) {
			int quantity;
			if (cart.containsKey(item)) {
				quantity = ((Integer) cart.get(item)).intValue() + 1;
			} else {
				quantity = 1;
			}
			cart.put(item, new Integer(quantity));
		}
	}

	public void removeItem(String item) {
		if (item != null && products.containsKey(item)) {
			int quantity = ((Integer) cart.get(item)).intValue() - 1;
			if (quantity > 0) {
				cart.put(item, new Integer(quantity));
			} else {
				cart.remove(item);
			}
		}
	}

	public Map getCart() {
		return cart;
	}

	public Integer getValue() {
		int result = 0;
		Iterator i = cart.values().iterator();
		while (i.hasNext()) {
			int c = ((Integer) i.next()).intValue();
			result += c;
		}
		return new Integer(result);
	}

}
