/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerWorkerProgressEvent.as 3591 2009-04-28 08:33:26Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.event {

    import com.adobe.cairngorm.control.*;
    import mx.managers.CursorManager;
    import org.ow2.jasmine.jadort.client.flex.model.*;
    import org.ow2.jasmine.jadort.client.flex.vo.*;

    /**
     * Updates the global server and worker progress bar.
     */
    public class ServerWorkerProgressEvent extends JadortEvent {

        /**
         * Name of the Event.
         */
        public static const EVENT_SERVER_WORKER_PROGRESS : String = "serverWorkerProgress";

        private var _progressPercent : Number;
        private var _progressError : Boolean;

        public function ServerWorkerProgressEvent() {
            super(EVENT_SERVER_WORKER_PROGRESS);

            var running : Boolean = false;

            _progressError = false;
            _progressPercent = 0;

            var deployCount : Number = 0;
            var model : JadortModelLocator = JadortModelLocator.getInstance();

            if (model.serverProgressList != null) {
                for each(var serverProgress : ServerProgressVO in model.serverProgressList) {
                    if (serverProgress.state.toLowerCase().indexOf("error") != -1) {
                        _progressError = true;
                    } else if (serverProgress.state.toLowerCase().indexOf("running") != -1) {
                        running = true;
                    }
                    _progressPercent += serverProgress.progress;
                    deployCount++;
                }
            }

            if (model.workerProgressList != null) {
                for each(var workerProgress : WorkerProgressVO in model.workerProgressList) {
                    if (workerProgress.state.toLowerCase().indexOf("error") != -1) {
                        _progressError = true;
                    } else if (workerProgress.state.toLowerCase().indexOf("running") != -1) {
                        running = true;
                    }
                    _progressPercent += workerProgress.progress;
                    deployCount++;
                }
            }

            if (deployCount > 0) {
                _progressPercent /= deployCount;
            } else {
                _progressPercent = 0;
            }

            if (running) {
                CursorManager.setBusyCursor();
            } else {
                CursorManager.removeBusyCursor();
            }
        }

        public function get progressPercent() : Number {
            return this._progressPercent;
        }

        public function get progressError() : Boolean {
            return this._progressError;
        }
    }
}
