/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.EjbServiceInvoker;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceFactory
extends ServiceFactory {
    private static final long serialVersionUID = 1L;
    private final ReentrantLock lock = new ReentrantLock();
    private String lookup = null;

    public String getLookup() {
        return this.lookup;
    }

    @Override
    public void configure(Map<String, Object> properties) throws ServiceException {
        super.configure(properties);
        this.lookup = (String)properties.get("lookup");
    }

    @Override
    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Map<String, Object> cache = context.getApplicationMap();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        String key = String.valueOf(EjbServiceInvoker.class.getName()) + '.' + destinationId;
        return this.getServiceInvoker(cache, destination, key);
    }

    private ServiceInvoker<?> getServiceInvoker(Map<String, Object> cache, Destination destination, String key) {
        this.lock.lock();
        try {
            ServiceInvoker invoker = (ServiceInvoker)cache.get(key);
            if (invoker == null) {
                invoker = new EjbServiceInvoker(destination, this);
                cache.put(key, invoker);
            }
            ServiceInvoker serviceInvoker = invoker;
            return serviceInvoker;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        return this.toString("\n  lookup: " + this.lookup);
    }
}

