/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import macromedia.abc.BytecodeBuffer;
import macromedia.asc.embedding.avmplus.ActivationBuilder;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.FunctionBuilder;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntList;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbcParser {
    private Context ctx;
    private BytecodeBuffer buf;
    private static final boolean debug = false;
    private int[] cPoolIntPositions;
    private int[] cPoolUIntPositions;
    private int[] cPoolDoublePositions;
    private String[] cPoolStrs;
    private int[] cPoolNsPositions;
    private int[] cPoolNsSetPositions;
    private int[] cPoolMnPositions;
    private int[] methodPositions;
    private int[] metadataPositions;
    private int[] instancePositions;
    private int[] classPositions;
    private int[] scriptPositions;
    private final Map<String, Integer> fun_names = new HashMap<String, Integer>();
    private final Map<String, ClassDefinitionNode> class_nodes = new HashMap<String, ClassDefinitionNode>();
    private final ObjectList<ObjectList<ClassDefinitionNode>> clsdefs_sets = new ObjectList();
    private final ObjectList<String> region_name_stack = new ObjectList();

    public AbcParser(Context context, String string) throws IOException {
        this.ctx = context;
        this.buf = new BytecodeBuffer(string);
    }

    public AbcParser(Context context, byte[] byArray) {
        this.ctx = context;
        this.buf = new BytecodeBuffer(byArray);
    }

    public ProgramNode parseAbc() {
        try {
            int n;
            this.buf.readU16();
            this.buf.readU16();
            this.scanCpool();
            this.scanMethods();
            this.scanMetadata();
            this.scanClasses();
            this.scanScripts();
            BinaryProgramNode binaryProgramNode = this.ctx.getNodeFactory().binaryProgram(this.ctx, this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null));
            binaryProgramNode.frame = new ObjectValue(this.ctx, new GlobalBuilder(), this.ctx.noType());
            GlobalBuilder globalBuilder = (GlobalBuilder)binaryProgramNode.frame.builder;
            globalBuilder.is_in_package = true;
            this.ctx.pushScope(binaryProgramNode.frame);
            this.clsdefs_sets.add(new ObjectList());
            this.region_name_stack.push_back("");
            for (n = 0; n < this.scriptPositions.length; ++n) {
                this.parseScript(n, binaryProgramNode);
            }
            binaryProgramNode.clsdefs = this.clsdefs_sets.last();
            for (n = 0; n < binaryProgramNode.statements.items.size(); ++n) {
                Node node = (Node)binaryProgramNode.statements.items.get(n);
                if (!(node instanceof ClassDefinitionNode)) continue;
                NodeFactory nodeFactory = this.ctx.getNodeFactory();
                binaryProgramNode.statements.items.set(n, nodeFactory.emptyStatement());
            }
            this.clsdefs_sets.removeLast();
            this.region_name_stack.pop_back();
            this.ctx.popScope();
            ProgramNode programNode = this.ctx.getNodeFactory().program(this.ctx, this.ctx.getNodeFactory().statementList(null, binaryProgramNode));
            return programNode;
        }
        catch (Exception exception) {
            ObjectValue objectValue = this.ctx.scope();
            ObjectValue objectValue2 = this.ctx.globalScope();
            while (objectValue != objectValue2) {
                this.ctx.popScope();
                objectValue = this.ctx.scope();
            }
            return null;
        }
    }

    void scanCpool() {
        long l;
        int n;
        int n2 = this.buf.readU32();
        this.cPoolIntPositions = new int[n2];
        for (n = 1; n < n2; ++n) {
            this.cPoolIntPositions[n] = this.buf.pos();
            this.buf.readU32();
        }
        n2 = this.buf.readU32();
        this.cPoolUIntPositions = new int[n2];
        for (n = 1; n < n2; ++n) {
            this.cPoolUIntPositions[n] = this.buf.pos();
            this.buf.readU32();
        }
        n2 = this.buf.readU32();
        this.cPoolDoublePositions = new int[n2];
        for (n = 1; n < n2; ++n) {
            this.cPoolDoublePositions[n] = this.buf.pos();
            this.buf.readDouble();
        }
        n2 = this.buf.readU32();
        this.cPoolStrs = new String[n2 > 0 ? n2 : 1];
        this.cPoolStrs[0] = "";
        for (n = 1; n < n2; ++n) {
            l = this.buf.readU32();
            this.cPoolStrs[n] = this.buf.readString((int)l).intern();
            this.buf.skip(l);
        }
        n2 = this.buf.readU32();
        this.cPoolNsPositions = new int[n2];
        for (n = 1; n < n2; ++n) {
            this.cPoolNsPositions[n] = this.buf.pos();
            this.buf.readU8();
            this.buf.readU32();
        }
        n2 = this.buf.readU32();
        this.cPoolNsSetPositions = new int[n2];
        for (n = 1; n < n2; ++n) {
            this.cPoolNsSetPositions[n] = this.buf.pos();
            l = this.buf.readU32();
            for (long i = 0L; i < l; ++i) {
                this.buf.readU32();
            }
        }
        n2 = this.buf.readU32();
        this.cPoolMnPositions = new int[n2];
        block13: for (n = 1; n < n2; ++n) {
            this.cPoolMnPositions[n] = this.buf.pos();
            int n3 = this.buf.readU8();
            switch (n3) {
                case 7: 
                case 13: {
                    this.buf.readU32();
                    this.buf.readU32();
                    continue block13;
                }
                case 15: 
                case 16: {
                    this.buf.readU32();
                    continue block13;
                }
                case 9: 
                case 14: {
                    this.buf.readU32();
                    this.buf.readU32();
                    continue block13;
                }
                case 27: 
                case 28: {
                    this.buf.readU32();
                    continue block13;
                }
            }
        }
    }

    void scanMethods() {
        long l = this.buf.readU32();
        this.methodPositions = new int[(int)l];
        int n = 0;
        while ((long)n < l) {
            long l2;
            this.methodPositions[n] = this.buf.pos();
            long l3 = this.buf.readU32();
            this.buf.readU32();
            this.buf.skipEntries(l3);
            this.buf.readU32();
            int n2 = this.buf.readU8();
            long l4 = (n2 & 8) != 0 ? (long)this.buf.readU32() : 0L;
            for (l2 = 0L; l2 < l4; ++l2) {
                this.buf.readU32();
                this.buf.readU8();
            }
            l2 = (n2 & 0x80) != 0 ? l3 : 0L;
            for (long i = 0L; i < l2; ++i) {
                this.buf.readU32();
            }
            ++n;
        }
    }

    void scanMetadata() {
        long l = this.buf.readU32();
        this.metadataPositions = new int[(int)l];
        int n = 0;
        while ((long)n < l) {
            this.metadataPositions[n] = this.buf.pos();
            this.buf.readU32();
            long l2 = this.buf.readU32();
            this.buf.skipEntries(l2 * 2L);
            ++n;
        }
    }

    void scanClasses() {
        long l = this.buf.readU32();
        this.classPositions = new int[(int)l];
        this.instancePositions = new int[(int)l];
        int n = 0;
        while ((long)n < l) {
            this.instancePositions[n] = this.buf.pos();
            this.buf.readU32();
            this.buf.readU32();
            int n2 = this.buf.readU8();
            if ((n2 & 8) != 0) {
                this.buf.readU32();
            }
            long l2 = this.buf.readU32();
            this.buf.skipEntries(l2);
            this.buf.readU32();
            this.skipTraits();
            ++n;
        }
        n = 0;
        while ((long)n < l) {
            this.classPositions[n] = this.buf.pos();
            this.buf.readU32();
            this.skipTraits();
            ++n;
        }
    }

    void scanScripts() {
        long l = this.buf.readU32();
        this.scriptPositions = new int[(int)l];
        int n = 0;
        while ((long)n < l) {
            this.scriptPositions[n] = this.buf.pos();
            this.buf.readU32();
            this.skipTraits();
            ++n;
        }
    }

    void skipTraits() {
        long l = this.buf.readU32();
        int n = 0;
        while ((long)n < l) {
            this.buf.readU32();
            int n2 = this.buf.readU8();
            int n3 = n2 & 0xF;
            switch (n3) {
                case 0: 
                case 6: {
                    this.buf.skipEntries(2L);
                    int n4 = this.buf.readU32();
                    if (n4 <= 0) break;
                    this.buf.readU32();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.buf.skipEntries(2L);
                    break;
                }
                case 4: 
                case 5: {
                    this.buf.skipEntries(2L);
                    break;
                }
            }
            if ((n2 >> 4 & 4) != 0) {
                long l2 = this.buf.readU32();
                this.buf.skipEntries(l2);
            }
            ++n;
        }
    }

    DefAndSlot slotTrait(int n, int n2, int n3, int n4, int n5, boolean bl) {
        Node node;
        Object object;
        ObjectValue objectValue = this.ctx.scope();
        DefAndSlot defAndSlot = new DefAndSlot();
        QName qName = this.getQNameFromCPool(n);
        String string = this.getStringFromCPool(qName.name);
        ObjectValue objectValue2 = this.getNamespace(qName.nameSpace);
        Namespaces namespaces = new Namespaces();
        namespaces.push_back(objectValue2);
        TypeValue typeValue = this.ctx.noType();
        int n6 = objectValue.builder.Variable(this.ctx, objectValue);
        int n7 = objectValue.builder.ExplicitVar(this.ctx, objectValue, string, namespaces, typeValue, -1, -1, n6);
        Slot slot = objectValue.getSlot(this.ctx, n7);
        slot.setConst(bl);
        slot.setImported(true);
        defAndSlot.slot = slot;
        IdentifierNode identifierNode = this.identifierNode(string, objectValue2);
        AttributeListNode attributeListNode = this.attributeList(false, false, false, objectValue2, objectValue.builder);
        if (n5 == 8) {
            ObjectValue objectValue3 = this.getNamespace(n4);
            slot.setObjectValue(objectValue3);
            slot.setConst(true);
            defAndSlot.def = this.ctx.getNodeFactory().namespaceDefinition(attributeListNode, identifierNode, this.ctx.getNodeFactory().literalString(objectValue3.name));
            return defAndSlot;
        }
        MemberExpressionNode memberExpressionNode = null;
        IdentifierNode identifierNode2 = null;
        if (n3 != 0) {
            object = this.getQNameFromCPool(n3);
            macromedia.asc.semantics.QName qName2 = this.getFullName((QName)object);
            identifierNode2 = this.identifierNode(qName2.name, qName2.ns);
            node = this.ctx.getNodeFactory().getExpression(identifierNode2);
            memberExpressionNode = this.ctx.getNodeFactory().memberExpression(null, (SelectorNode)node);
        } else {
            memberExpressionNode = null;
        }
        object = this.getInitValue(n4, n5);
        node = this.ctx.getNodeFactory().typedIdentifier(identifierNode, memberExpressionNode);
        int n8 = bl ? -64 : -111;
        VariableBindingNode variableBindingNode = this.ctx.getNodeFactory().variableBinding(attributeListNode, n8, (TypedIdentifierNode)node, (Node)object);
        variableBindingNode.ref = identifierNode.ref;
        if (identifierNode2 != null) {
            variableBindingNode.typeref = identifierNode2.ref;
        }
        defAndSlot.def = (DefinitionNode)this.ctx.getNodeFactory().variableDefinition(attributeListNode, n8, this.ctx.getNodeFactory().list(null, variableBindingNode));
        return defAndSlot;
    }

    private IdentifierNode identifierNode(String string, ObjectValue objectValue) {
        IdentifierNode identifierNode = this.ctx.getNodeFactory().identifier(string);
        identifierNode.ref = new ReferenceValue(this.ctx, null, identifierNode.name, objectValue);
        return identifierNode;
    }

    DefAndSlot methodTrait(int n, int n2, int n3, int n4, int n5) {
        QName qName = this.getQNameFromCPool(n);
        String string = this.getStringFromCPool(qName.name);
        ObjectValue objectValue = this.getNamespace(qName.nameSpace);
        return this.methodTrait(string, objectValue, n2, n3, n4, n5);
    }

    DefAndSlot methodTrait(String string, ObjectValue objectValue, int n, int n2, int n3, int n4) {
        Node node;
        Object object;
        Object object2;
        Object object3;
        int n5;
        int n6;
        int n7;
        ObjectValue objectValue2 = this.ctx.scope();
        DefAndSlot defAndSlot = new DefAndSlot();
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        Namespaces namespaces = new Namespaces();
        namespaces.push_back(objectValue);
        switch (n4) {
            case 3: {
                int n8 = objectValue2.builder.Method(this.ctx, objectValue2, string, namespaces, false);
                n7 = objectValue2.builder.ExplicitSet(this.ctx, objectValue2, string, namespaces, this.ctx.noType(), bl, bl2, -1, n8, -1);
                break;
            }
            case 2: {
                int n8 = objectValue2.builder.Method(this.ctx, objectValue2, string, namespaces, false);
                n7 = objectValue2.builder.ExplicitGet(this.ctx, objectValue2, string, namespaces, this.ctx.noType(), bl, bl2, -1, n8, -1);
                break;
            }
            default: {
                int n8 = objectValue2.builder.Method(this.ctx, objectValue2, string, namespaces, false);
                n7 = objectValue2.builder.ExplicitCall(this.ctx, objectValue2, string, namespaces, this.ctx.noType(), bl, bl2, -1, n8, -1);
            }
        }
        ObjectValue objectValue3 = new ObjectValue(this.ctx, new FunctionBuilder(), this.ctx.functionType());
        Slot slot = objectValue2.getSlot(this.ctx, n7);
        slot.setObjectValue(objectValue3);
        slot.setImported(true);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        if (!this.fun_names.containsKey(string)) {
            this.fun_names.put(string, Boxing.valueOf(0));
        }
        stringBuffer.append(string).append('$');
        int n9 = this.fun_names.get(string);
        stringBuffer.append(n9);
        this.fun_names.put(string, Boxing.valueOf(++n9));
        int n10 = objectValue2.getImplicitIndex(this.ctx, n7, -132);
        Slot slot2 = objectValue2.getSlot(this.ctx, n10);
        slot2.setImported(true);
        String string2 = stringBuffer.toString();
        slot2.setMethodName(string2);
        slot.getObjectValue().name = string2;
        defAndSlot.slot = slot2;
        switch (n4) {
            case 2: {
                n6 = -78;
                break;
            }
            case 3: {
                n6 = -98;
                break;
            }
            default: {
                n6 = -132;
            }
        }
        int n11 = this.buf.pos();
        this.buf.seek(this.methodPositions[n2]);
        int n12 = this.buf.readU32();
        int n13 = this.buf.readU32();
        int[] nArray = new int[n12];
        for (n5 = 0; n5 < n12; ++n5) {
            nArray[n5] = this.buf.readU32();
        }
        this.buf.readU32();
        n5 = this.buf.readU8();
        boolean bl3 = (n5 & 4) != 0;
        boolean bl4 = (n5 & 8) != 0;
        boolean bl5 = (n5 & 0x80) != 0;
        int n14 = 0;
        ObjectList<Node> objectList = null;
        if (bl4) {
            objectList = this.parseOptionalParams();
            n14 = objectList.size();
        }
        String[] stringArray = new String[n12 + n14];
        if (bl5) {
            for (int i = 0; i < n12; ++i) {
                stringArray[i] = this.getStringFromCPool(this.buf.readU32());
            }
        }
        this.buf.seek(n11);
        MemberExpressionNode memberExpressionNode = null;
        if (n13 != 0) {
            object3 = this.getQNameFromCPool(n13);
            macromedia.asc.semantics.QName qName = this.getFullName((QName)object3);
            IdentifierNode identifierNode = this.identifierNode(qName.name, qName.ns);
            object2 = this.ctx.getNodeFactory().getExpression(identifierNode);
            memberExpressionNode = this.ctx.getNodeFactory().memberExpression(null, (SelectorNode)object2);
            memberExpressionNode.ref = identifierNode.ref;
        }
        object3 = null;
        objectValue3.activation = new ObjectValue(this.ctx, new ActivationBuilder(), this.ctx.noType());
        int n15 = 0;
        for (int i = 0; i < n12; ++i) {
            object2 = null;
            if (nArray[i] != 0) {
                object = this.getQNameFromCPool(nArray[i]);
                object2 = this.getFullName((QName)object);
            }
            object = stringArray[i] != null ? stringArray[i] : new StringBuffer().append("param").append(i + 1).toString().intern();
            node = this.parameterNode((String)object, (macromedia.asc.semantics.QName)object2);
            object3 = this.ctx.getNodeFactory().parameterList((ParameterListNode)object3, (ParameterNode)node);
            int n16 = objectValue3.activation.builder.Variable(this.ctx, objectValue3.activation);
            objectValue3.activation.builder.ExplicitVar(this.ctx, objectValue3.activation, (String)object, this.ctx.publicNamespace(), this.ctx.noType(), -1, -1, n16);
            if (!bl4 || i < n12 - n14) continue;
            node.init = (Node)objectList.get(n15++);
        }
        if (bl3) {
            ParameterNode parameterNode = this.parameterNode("rest", this.ctx.arrayType().name);
            n15 = objectValue3.activation.builder.Variable(this.ctx, objectValue3.activation);
            objectValue3.activation.builder.ExplicitVar(this.ctx, objectValue3.activation, "rest", this.ctx.publicNamespace(), this.ctx.arrayType(), -1, -1, n15);
            object2 = this.ctx.getNodeFactory().restParameter(parameterNode, -1);
            ((RestParameterNode)object2).ref = parameterNode.ref;
            ((RestParameterNode)object2).typeref = parameterNode.typeref;
            object3 = this.ctx.getNodeFactory().parameterList((ParameterListNode)object3, (ParameterNode)object2);
            this.ctx.getNodeFactory().has_rest = false;
        }
        FunctionSignatureNode functionSignatureNode = this.ctx.getNodeFactory().functionSignature((ParameterListNode)object3, memberExpressionNode);
        if (memberExpressionNode != null) {
            functionSignatureNode.typeref = memberExpressionNode.ref;
        }
        IdentifierNode identifierNode = this.identifierNode(string, objectValue);
        object2 = this.ctx.getNodeFactory().functionCommon(this.ctx, identifierNode, functionSignatureNode, null);
        ((FunctionCommonNode)object2).fun = objectValue3;
        ((FunctionCommonNode)object2).kind = n6;
        object = this.ctx.getNodeFactory().functionName(n6, identifierNode);
        node = this.attributeList(bl, bl2, false, objectValue, objectValue2.builder);
        BinaryFunctionDefinitionNode binaryFunctionDefinitionNode = this.ctx.getNodeFactory().binaryFunctionDefinition(this.ctx, (AttributeListNode)node, (FunctionNameNode)object, (FunctionCommonNode)object2, -1);
        ((FunctionNameNode)object).identifier.ref = ((FunctionCommonNode)object2).ref = new ReferenceValue(this.ctx, null, identifierNode.name, objectValue);
        defAndSlot.def = binaryFunctionDefinitionNode;
        return defAndSlot;
    }

    private Node getInitValue(int n, int n2) {
        Node node;
        NodeFactory nodeFactory = this.ctx.getNodeFactory();
        switch (n2) {
            case 0: {
                node = nodeFactory.unaryExpression(-112, nodeFactory.literalNumber("0", -1), -1);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                double d = this.getNumberFromCPool(n, n2);
                node = nodeFactory.literalNumber(String.valueOf(d));
                break;
            }
            case 11: {
                node = nodeFactory.literalBoolean(true);
                break;
            }
            case 10: {
                node = nodeFactory.literalBoolean(false);
                break;
            }
            case 1: {
                node = nodeFactory.literalString(this.getStringFromCPool(n));
                break;
            }
            case 12: {
                node = nodeFactory.literalNull();
                break;
            }
            case 8: {
                ObjectValue objectValue = this.getNamespace(n);
                node = nodeFactory.literalString(objectValue.name);
                break;
            }
            default: {
                node = nodeFactory.literalString("");
            }
        }
        return node;
    }

    private ObjectList<Node> parseOptionalParams() {
        int n = this.buf.readU32();
        ObjectList<Node> objectList = new ObjectList<Node>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.buf.readU32();
            int n3 = this.buf.readU8();
            Node node = this.getInitValue(n2, n3);
            objectList.push_back(node);
        }
        return objectList;
    }

    private ParameterNode parameterNode(String string, macromedia.asc.semantics.QName qName) {
        Node node;
        IdentifierNode identifierNode = this.identifierNode(string, this.ctx.publicNamespace());
        IdentifierNode identifierNode2 = null;
        MemberExpressionNode memberExpressionNode = null;
        if (qName != null) {
            identifierNode2 = this.identifierNode(qName.name, qName.ns);
            node = this.ctx.getNodeFactory().getExpression(identifierNode2);
            memberExpressionNode = this.ctx.getNodeFactory().memberExpression(null, (SelectorNode)node);
        }
        node = this.ctx.getNodeFactory().parameter(-111, identifierNode, memberExpressionNode);
        if (identifierNode2 != null) {
            node.typeref = identifierNode2.ref;
        }
        node.ref = identifierNode.ref;
        return node;
    }

    AttributeListNode attributeList(boolean bl, boolean bl2, boolean bl3, ObjectValue objectValue, Builder builder) {
        AttributeListNode attributeListNode = this.ctx.getNodeFactory().attributeList(this.ctx.getNodeFactory().literalString(""), null);
        attributeListNode.hasFinal = bl;
        attributeListNode.hasOverride = bl2;
        attributeListNode.hasDynamic = bl3;
        if (builder instanceof ClassBuilder) {
            attributeListNode.hasStatic = true;
        }
        if (objectValue != null && (objectValue == this.ctx.publicNamespace() || objectValue.getNamespaceKind() == 0 && objectValue.isPackage())) {
            attributeListNode.hasPublic = true;
        } else if (objectValue != null && objectValue.isInternal()) {
            attributeListNode.hasInternal = true;
        } else if (objectValue != null && objectValue.isProtected()) {
            attributeListNode.hasProtected = true;
        } else if (objectValue != null && objectValue.isPrivate()) {
            attributeListNode.hasPrivate = true;
        } else if (objectValue != null) {
            if (builder.classname != null && objectValue == builder.classname.ns) {
                attributeListNode.hasPublic = true;
            } else {
                attributeListNode.namespaces.add(objectValue);
            }
        }
        return attributeListNode;
    }

    macromedia.asc.semantics.QName getFullName(QName qName) {
        String string = this.getStringFromCPool(qName.name);
        ObjectValue objectValue = this.getNamespace(qName.nameSpace);
        return this.ctx.computeQualifiedName("", string, objectValue, -132);
    }

    DefAndSlot classTrait(int n, int n2, int n3) {
        Object n8;
        Node node;
        Node node2;
        Object object;
        Object object2;
        long l;
        int n4;
        if (n3 >= this.classPositions.length || n3 < 0) {
            return null;
        }
        DefAndSlot defAndSlot = new DefAndSlot();
        ObjectValue objectValue = this.ctx.scope();
        QName qName = this.getQNameFromCPool(n);
        String string = this.getStringFromCPool(qName.name);
        ObjectValue objectValue2 = this.getNamespace(qName.nameSpace);
        String string2 = this.region_name_stack.back();
        if (string2.length() > 0) {
            string2 = new StringBuffer().append(string2).append("/").toString();
            objectValue2 = this.ctx.getNamespace(new StringBuffer().append(string2).append(objectValue2.name).toString());
        }
        int n5 = this.instancePositions[n3];
        int n6 = this.classPositions[n3];
        int n7 = this.buf.pos();
        this.buf.seek(n5);
        long l2 = this.buf.readU32();
        QName qName2 = this.getQNameFromCPool((int)l2);
        macromedia.asc.semantics.QName qName3 = this.getFullName(qName2);
        long l3 = this.buf.readU32();
        boolean bl2 = false;
        macromedia.asc.semantics.QName qName4 = null;
        String string3 = "";
        ObjectValue objectValue3 = null;
        if (l3 != 0L) {
            bl2 = true;
            QName qName5 = this.getQNameFromCPool((int)l3);
            objectValue3 = this.getNamespace(qName5.nameSpace);
            qName4 = this.getFullName(qName5);
            string3 = this.getStringFromCPool(qName5.name);
        }
        if (((n4 = this.buf.readU8()) & 8) != 0) {
            this.buf.readU32();
        }
        long l4 = this.buf.readU32();
        ListNode listNode = null;
        for (l = 0L; l < l4; ++l) {
            int bl = this.buf.readU32();
            QName bl3 = this.getMultinameFromCPool(bl);
            String bl4 = this.getStringFromCPool(bl3.name);
            object2 = this.getNamespaces(bl3.nameSpace);
            object = this.ctx.getNodeFactory().identifier(bl4);
            ((IdentifierNode)object).ref = new ReferenceValue(this.ctx, null, bl4, (Namespaces)object2);
            node2 = this.ctx.getNodeFactory().getExpression((IdentifierNode)object);
            node = this.ctx.getNodeFactory().memberExpression(null, (SelectorNode)node2);
            ((MemberExpressionNode)node).ref = ((IdentifierNode)object).ref;
            listNode = this.ctx.getNodeFactory().list(listNode, node);
            listNode.values.push_back(((IdentifierNode)object).ref);
        }
        l = this.buf.readU32();
        boolean bl = (n4 & 2) != 0;
        boolean bl3 = (n4 & 1) == 0;
        boolean bl4 = (n4 & 4) != 0;
        node2 = null;
        node = this.ctx.getNodeFactory().identifier(string);
        node.ref = new ReferenceValue(this.ctx, null, node.name, objectValue2);
        AttributeListNode attributeListNode = this.attributeList(bl, false, bl3, objectValue2, objectValue.builder);
        node2 = bl4 ? this.ctx.getNodeFactory().binaryInterfaceDefinition(this.ctx, attributeListNode, (IdentifierNode)node, null, this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null)) : this.ctx.getNodeFactory().binaryClassDefinition(this.ctx, attributeListNode, (IdentifierNode)node, null, this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null));
        ((ClassDefinitionNode)node2).ref = node.ref;
        ((ClassDefinitionNode)node2).interfaces = listNode;
        ((ClassDefinitionNode)node2).protected_namespace = this.ctx.getNamespace(qName3.toString(), (byte)3);
        ((ClassDefinitionNode)node2).static_protected_namespace = this.ctx.getNamespace(qName3.toString(), (byte)5);
        boolean bl5 = this.ctx.isBuiltin(qName3.toString());
        if (bl5) {
            object2 = this.ctx.builtin(qName3.toString());
            ((ClassDefinitionNode)node2).cframe = object2;
            object = ((TypeValue)object2).prototype;
            ((ClassDefinitionNode)node2).iframe = object;
        } else {
            object2 = TypeValue.newTypeValue(this.ctx, new ClassBuilder(qName3, ((ClassDefinitionNode)node2).protected_namespace, ((ClassDefinitionNode)node2).static_protected_namespace), qName3, 8192);
            ((ClassDefinitionNode)node2).cframe = object2;
            object = new ObjectValue(this.ctx, new InstanceBuilder(qName3), (TypeValue)object2);
            ((ClassDefinitionNode)node2).iframe = object;
            ((TypeValue)object2).prototype = object;
            ((InstanceBuilder)((ObjectValue)object).builder).canEarlyBind = false;
            ((ClassDefinitionNode)node2).debug_name = qName3.toString();
            ((ClassDefinitionNode)node2).owns_cframe = true;
        }
        if (bl4) {
            ((ClassBuilder)((ClassDefinitionNode)node2).cframe.builder).is_interface = true;
        }
        ((ClassDefinitionNode)node2).cframe.builder.is_dynamic = ((ClassDefinitionNode)node2).iframe.builder.is_dynamic = bl3;
        ((ClassDefinitionNode)node2).cframe.builder.is_final = ((ClassDefinitionNode)node2).iframe.builder.is_final = bl;
        this.class_nodes.put(qName3.toString(), (ClassDefinitionNode)node2);
        this.clsdefs_sets.last().add((ClassDefinitionNode)node2);
        if (bl2) {
            ((ClassDefinitionNode)node2).baseclass = this.ctx.getNodeFactory().literalString(qName4.toString(), -1);
            if (this.ctx.isBuiltin(qName4.toString())) {
                ((TypeValue)object2).baseclass = n8 = this.ctx.builtin(qName4.toString());
                ((ClassDefinitionNode)node2).baseref = new ReferenceValue(this.ctx, null, qName4.toString(), this.ctx.publicNamespace());
            } else {
                ((ClassDefinitionNode)node2).baseref = new ReferenceValue(this.ctx, null, string3, objectValue3);
                ((ClassDefinitionNode)node2).baseref.getSlot(this.ctx);
            }
        } else if (((ClassDefinitionNode)node2).cframe != this.ctx.objectType()) {
            n8 = this.ctx.getNodeFactory();
            ((ClassDefinitionNode)node2).baseclass = ((NodeFactory)n8).memberExpression(null, ((NodeFactory)n8).getExpression(((NodeFactory)n8).identifier("Object")));
            ((TypeValue)object2).baseclass = this.ctx.objectType();
        } else {
            ((ClassDefinitionNode)node2).baseclass = null;
            ((TypeValue)object2).baseclass = null;
        }
        ((TypeValue)object2).builder.is_final = bl;
        ((TypeValue)object2).builder.is_dynamic = bl3;
        int n9 = objectValue.builder.Variable(this.ctx, objectValue);
        int n10 = objectValue.builder.ExplicitVar(this.ctx, objectValue, string, objectValue2, this.ctx.typeType(), -1, -1, n9);
        Slot slot = objectValue.getSlot(this.ctx, n10);
        slot.setObjectValue((ObjectValue)object2);
        slot.setImported(true);
        slot.setConst(true);
        defAndSlot.slot = slot;
        objectValue.builder.ImplicitCall(this.ctx, objectValue, n10, (TypeValue)object2, 16, -1, -1);
        objectValue.builder.ImplicitConstruct(this.ctx, objectValue, n10, (TypeValue)object2, 16, -1, -1);
        if (bl4) {
            ((ClassBuilder)((TypeValue)object2).builder).is_interface = true;
            slot.setImplNode(node2);
        }
        this.clsdefs_sets.add(new ObjectList());
        this.region_name_stack.push_back(qName3.toString());
        this.ctx.pushStaticClassScopes((ClassDefinitionNode)node2);
        this.ctx.pushScope((ObjectValue)object);
        StatementListNode statementListNode = this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null);
        this.parseTraits(null, statementListNode);
        ((ClassDefinitionNode)node2).instanceinits = new ObjectList(statementListNode.items.size());
        if (statementListNode.items.size() > 0) {
            ((ClassDefinitionNode)node2).instanceinits.addAll(statementListNode.items);
        }
        DefinitionNode definitionNode = this.methodTrait((String)"$construct", (ObjectValue)this.ctx.publicNamespace(), (int)0, (int)((int)l), (int)0, (int)0).def;
        ((ClassDefinitionNode)node2).instanceinits.add(definitionNode);
        this.ctx.popScope();
        this.buf.seek(n6);
        this.buf.readU32();
        this.parseTraits(null, ((ClassDefinitionNode)node2).statements);
        this.ctx.popStaticClassScopes((ClassDefinitionNode)node2);
        this.buf.seek(n7);
        this.clsdefs_sets.removeLast();
        this.region_name_stack.pop_back();
        defAndSlot.def = node2;
        return defAndSlot;
    }

    void parseTraits(BinaryProgramNode binaryProgramNode, StatementListNode statementListNode) {
        long l = this.buf.readU32();
        for (long i = 0L; i < l; ++i) {
            long l2 = this.buf.readU32();
            int n = this.buf.readU8();
            int n2 = n & 0xF;
            int n3 = 0;
            DefAndSlot defAndSlot = null;
            switch (n2) {
                case 0: 
                case 6: {
                    long l3 = this.buf.readU32();
                    long l4 = this.buf.readU32();
                    long l5 = this.buf.readU32();
                    if (l5 > 0L) {
                        n3 = this.buf.readU8();
                    }
                    defAndSlot = this.slotTrait((int)l2, (int)l3, (int)l4, (int)l5, n3, n2 == 6);
                    statementListNode.items.add(defAndSlot.def);
                    if (binaryProgramNode == null) break;
                    QName qName = this.getQNameFromCPool((int)l2);
                    String string = this.getStringFromCPool(qName.name);
                    ObjectValue objectValue = this.getNamespace(qName.nameSpace);
                    binaryProgramNode.toplevelDefinitions.add(new macromedia.asc.semantics.QName(objectValue, string));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    long l6 = this.buf.readU32();
                    long l7 = this.buf.readU32();
                    int n4 = n >> 4;
                    defAndSlot = this.methodTrait((int)l2, (int)l6, (int)l7, n4, n2);
                    statementListNode.items.add(defAndSlot.def);
                    if (binaryProgramNode == null) break;
                    QName qName = this.getQNameFromCPool((int)l2);
                    String string = this.getStringFromCPool(qName.name);
                    ObjectValue objectValue = this.getNamespace(qName.nameSpace);
                    binaryProgramNode.toplevelDefinitions.add(new macromedia.asc.semantics.QName(objectValue, string));
                    break;
                }
                case 4: {
                    long l3 = this.buf.readU32();
                    long l8 = this.buf.readU32();
                    defAndSlot = this.classTrait((int)l2, (int)l3, (int)l8);
                    statementListNode.items.add(defAndSlot.def);
                    if (binaryProgramNode == null) break;
                    QName qName = this.getQNameFromCPool((int)l2);
                    String string = this.getStringFromCPool(qName.name);
                    ObjectValue objectValue = this.getNamespace(qName.nameSpace);
                    binaryProgramNode.toplevelDefinitions.add(new macromedia.asc.semantics.QName(objectValue, string));
                    break;
                }
                case 5: {
                    this.buf.skipEntries(2L);
                    break;
                }
            }
            if ((n >> 4 & 4) == 0) continue;
            long l9 = this.buf.readU32();
            int n5 = 0;
            while ((long)n5 < l9) {
                long l10 = this.buf.readU32();
                MetaDataNode metaDataNode = this.parseMetadataInfo((int)l10);
                if (defAndSlot != null) {
                    if (defAndSlot.def != null) {
                        metaDataNode.def = defAndSlot.def;
                        defAndSlot.def.addMetaDataNode(metaDataNode);
                        statementListNode.items.add(metaDataNode);
                    }
                    if (defAndSlot.slot != null && "Deprecated" == metaDataNode.id) {
                        defAndSlot.slot.addMetadata(metaDataNode);
                    }
                }
                ++n5;
            }
        }
    }

    void parseScript(int n, BinaryProgramNode binaryProgramNode) {
        if (n < 0 || n >= this.scriptPositions.length) {
            return;
        }
        int n2 = this.buf.pos();
        this.buf.seek(this.scriptPositions[n]);
        this.buf.readU32();
        this.parseTraits(binaryProgramNode, binaryProgramNode.statements);
        this.buf.seek(n2);
    }

    MetaDataNode parseMetadataInfo(int n) {
        int n2 = this.metadataPositions[n];
        int n3 = this.buf.pos();
        this.buf.seek(n2);
        long l = this.buf.readU32();
        long l2 = this.buf.readU32();
        MetaDataNode metaDataNode = this.ctx.getNodeFactory().metaData(null, -1);
        metaDataNode.id = this.getStringFromCPool((int)l);
        if (l2 > 0L) {
            IntList intList = new IntList((int)l2);
            IntList intList2 = new IntList((int)l2);
            int n4 = 0;
            while ((long)n4 < l2) {
                intList.add(this.buf.readU32());
                ++n4;
            }
            n4 = 0;
            while ((long)n4 < l2) {
                intList2.add(this.buf.readU32());
                ++n4;
            }
            metaDataNode.values = new Value[(int)l2];
            n4 = 0;
            while ((long)n4 < l2) {
                int n5 = intList.get(n4);
                int n6 = intList2.get(n4);
                Value value = null;
                value = n5 == 0 ? new MetaDataEvaluator.KeylessValue(this.getStringFromCPool(n6)) : new MetaDataEvaluator.KeyValuePair(this.getStringFromCPool(n5), this.getStringFromCPool(n6));
                metaDataNode.values[n4] = value;
                ++n4;
            }
        }
        this.buf.seek(n3);
        return metaDataNode;
    }

    String getStringFromCPool(int n) {
        return this.cPoolStrs[n];
    }

    double getNumberFromCPool(int n, int n2) {
        double d = 0.0;
        int[] nArray = null;
        switch (n2) {
            case 3: {
                nArray = this.cPoolIntPositions;
                break;
            }
            case 4: {
                nArray = this.cPoolUIntPositions;
                break;
            }
            case 6: {
                nArray = this.cPoolDoublePositions;
            }
        }
        if (nArray != null) {
            int n3 = nArray[n];
            int n4 = this.buf.pos();
            this.buf.seek(n3);
            switch (n2) {
                case 3: {
                    d = this.buf.readU32();
                    break;
                }
                case 4: {
                    d = (long)this.buf.readU32() & 0xFFFFFFFFL;
                    break;
                }
                case 6: {
                    d = this.buf.readDouble();
                }
            }
            this.buf.seek(n4);
        }
        return d;
    }

    QName getQNameFromCPool(int n) {
        int n2 = this.buf.pos();
        QName qName = new QName();
        qName.nameSpace = 0;
        qName.name = 0;
        this.buf.seek(this.cPoolMnPositions[n]);
        int n3 = this.buf.readU8();
        switch (n3) {
            case 7: 
            case 13: {
                qName.nameSpace = this.buf.readU32();
                qName.name = this.buf.readU32();
                break;
            }
        }
        this.buf.seek(n2);
        return qName;
    }

    QName getMultinameFromCPool(int n) {
        int n2 = this.buf.pos();
        QName qName = new QName();
        qName.nameSpace = 0;
        qName.name = 0;
        this.buf.seek(this.cPoolMnPositions[n]);
        int n3 = this.buf.readU8();
        switch (n3) {
            case 9: 
            case 14: {
                qName.name = this.buf.readU32();
                qName.nameSpace = this.buf.readU32();
                break;
            }
        }
        this.buf.seek(n2);
        return qName;
    }

    Namespaces getNamespaces(int n) {
        int n2 = this.buf.pos();
        this.buf.seek(this.cPoolNsSetPositions[n]);
        int n3 = this.buf.readU32();
        Namespaces namespaces = new Namespaces(n3);
        for (int i = 0; i < n3; ++i) {
            namespaces.add(this.getNamespace(this.buf.readU32()));
        }
        this.buf.seek(n2);
        return namespaces;
    }

    ObjectValue getNamespace(int n) {
        ObjectValue objectValue = null;
        if (n == 0) {
            objectValue = this.ctx.anyNamespace();
        } else {
            int n2 = this.buf.pos();
            this.buf.seek(this.cPoolNsPositions[n]);
            int n3 = this.buf.readU8();
            switch (n3) {
                case 8: {
                    objectValue = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()));
                    break;
                }
                case 22: {
                    objectValue = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()));
                    objectValue.setPackage(true);
                    break;
                }
                case 24: {
                    objectValue = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)3);
                    break;
                }
                case 23: {
                    objectValue = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)1);
                    break;
                }
                case 5: {
                    objectValue = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)2);
                    break;
                }
                case 25: {
                    objectValue = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)4);
                    break;
                }
                case 26: {
                    objectValue = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)5);
                }
            }
            this.buf.seek(n2);
        }
        return objectValue;
    }

    static final class QName {
        int name;
        int nameSpace;

        QName() {
        }
    }

    private static class DefAndSlot {
        public DefinitionNode def;
        public Slot slot;

        private DefAndSlot() {
        }
    }
}

