/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.parser.InputBufferStream;
import macromedia.asc.util.IntList;

public final class InputBuffer {
    private StringBuffer text;
    private IntList line_breaks;
    private boolean atEOF = false;
    public Reader in;
    private int pushBackChar = -1;
    public String origin;
    public StringBuffer curr_line;
    public StringBuffer prev_line;
    public StringBuffer raw_curr_line;
    public int curr_line_offset;
    public int prev_line_offset;
    public int pos;
    public int colPos;
    public int lnNum;
    public boolean has_unixnewlines;
    public boolean report_pos = true;
    private byte[] bom = new byte[3];
    public int markCol;
    public int markLn;

    public InputBuffer(InputStream inputStream, String string, String string2) {
        this.in = this.createReader(inputStream, string);
        this.text = new StringBuffer(8192);
        this.init(string2, 0);
    }

    public InputBuffer(String string, String string2) {
        this.in = new StringReader(string);
        this.text = new StringBuffer(string.length() + 10);
        this.init(string2, 0);
    }

    private void init(String string, int n) {
        this.origin = string;
        this.curr_line = new StringBuffer(80);
        this.prev_line = new StringBuffer(80);
        this.prev_line_offset = -1;
        this.pos = n;
        this.lnNum = -1;
        this.colPos = 0;
        this.raw_curr_line = new StringBuffer(80);
        this.has_unixnewlines = false;
        this.line_breaks = new IntList(200);
        this.line_breaks.add(0);
    }

    private Reader createReader(InputStream inputStream, String string) {
        try {
            inputStream.read(this.bom, 0, 3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new StringReader("");
        }
        if (this.bom[0] == -17 && this.bom[1] == -69 && this.bom[2] == -65) {
            try {
                return new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new BufferedReader(new InputStreamReader(inputStream));
            }
        }
        if (this.bom[0] == -1 && this.bom[1] == -2 || this.bom[0] == -2 && this.bom[1] == -1) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new InputBufferStream(this.bom, inputStream), "UTF16"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new BufferedReader(new InputStreamReader(new InputBufferStream(this.bom, inputStream)));
            }
        }
        if (string != null) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new InputBufferStream(this.bom, inputStream), string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new BufferedReader(new InputStreamReader(new InputBufferStream(this.bom, inputStream)));
            }
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new InputBufferStream(this.bom, inputStream), "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedReader(new InputStreamReader(new InputBufferStream(this.bom, inputStream)));
        }
    }

    public int read() {
        if (this.atEOF) {
            return -1;
        }
        if (this.pushBackChar != -1) {
            int n = this.pushBackChar;
            this.pushBackChar = -1;
            ++this.pos;
            return n;
        }
        try {
            int n = this.in.read();
            if (n == -1) {
                this.atEOF = true;
            } else {
                this.text.append((char)n);
                ++this.pos;
            }
            return n;
        }
        catch (IOException iOException) {
            this.atEOF = true;
            ++this.pos;
            return -1;
        }
    }

    public String source() {
        return this.text.toString();
    }

    public String source(int n, int n2) {
        return this.text.substring(n, n2);
    }

    public int nextchar() {
        return this.nextchar(false);
    }

    public int nextchar(boolean bl) {
        int n = -1;
        if (this.colPos == this.curr_line.length()) {
            if (!this.atEOF) {
                ++this.lnNum;
            }
            this.colPos = 0;
            this.raw_curr_line.setLength(0);
            StringBuffer stringBuffer = this.prev_line;
            this.prev_line = this.curr_line;
            this.prev_line_offset = this.curr_line_offset;
            this.curr_line = stringBuffer;
            this.curr_line.setLength(0);
            this.curr_line_offset = this.pos;
            block8: while (n != 10 && n != 0) {
                int n2 = n;
                n = this.read();
                if (n2 == 13 && n != 10) {
                    this.pushBackChar = n;
                    --this.pos;
                    break;
                }
                block9: while (true) {
                    switch (n) {
                        case 1807: 
                        case 6155: 
                        case 6156: 
                        case 6157: 
                        case 6158: 
                        case 8204: 
                        case 8205: 
                        case 8206: 
                        case 8207: 
                        case 8234: 
                        case 8235: 
                        case 8236: 
                        case 8237: 
                        case 8238: 
                        case 8298: 
                        case 8299: 
                        case 8300: 
                        case 8301: 
                        case 8302: 
                        case 8303: 
                        case 65279: 
                        case 65529: 
                        case 65530: 
                        case 65531: {
                            n = this.read();
                            continue block9;
                        }
                    }
                    break;
                }
                switch (n) {
                    case 10: 
                    case 13: 
                    case 8232: 
                    case 8233: {
                        this.raw_curr_line.append((char)n);
                        if (n2 == 13 && n == 10) {
                            this.line_breaks.set(this.lnNum + 1, this.pos);
                            continue block8;
                        }
                        this.curr_line.append('\n');
                        this.line_breaks.resize(this.lnNum + 1);
                        this.line_breaks.set(this.lnNum + 1, this.pos);
                        continue block8;
                    }
                    case 9: 
                    case 11: 
                    case 12: 
                    case 32: 
                    case 160: {
                        this.raw_curr_line.append((char)n);
                        n = 32;
                        this.curr_line.append((char)n);
                        continue block8;
                    }
                    case -1: {
                        n = 0;
                        this.raw_curr_line.append((char)n);
                        this.curr_line.append((char)n);
                        continue block8;
                    }
                }
                this.raw_curr_line.append((char)n);
                this.curr_line.append((char)n);
            }
            if (bl) {
                return 10;
            }
        }
        n = bl ? this.raw_curr_line.charAt(this.colPos++) : this.curr_line.charAt(this.colPos++);
        return n;
    }

    public void retract() {
        if (--this.colPos < 0) {
            StringBuffer stringBuffer = this.curr_line;
            this.curr_line = this.prev_line;
            this.prev_line = stringBuffer;
            this.prev_line.setLength(0);
            --this.lnNum;
            this.colPos = this.curr_line.length() - 1;
            this.curr_line_offset = this.prev_line_offset;
        }
    }

    private final int unHex(char c) {
        return Character.digit(c, 16);
    }

    private final boolean isHex(char c) {
        return Character.digit(c, 16) != -1;
    }

    private final char javaTypeOfToCharacterClass(int n) {
        switch (n) {
            case 1: {
                return '\u0001';
            }
            case 2: {
                return '\u0002';
            }
            case 3: {
                return '\u0003';
            }
            case 6: {
                return '\u0004';
            }
            case 8: {
                return '\u0005';
            }
            case 7: {
                return '\u0006';
            }
            case 9: {
                return '\u0007';
            }
            case 10: {
                return '\b';
            }
            case 11: {
                return '\t';
            }
            case 12: {
                return '\n';
            }
            case 13: {
                return '\u000b';
            }
            case 14: {
                return '\f';
            }
            case 15: {
                return '\r';
            }
            case 16: {
                return '\u000e';
            }
            case 19: {
                return '\u000f';
            }
            case 18: {
                return '\u0010';
            }
            case 0: {
                return '\u0011';
            }
            case 4: {
                return '\u0012';
            }
            case 5: {
                return '\u0013';
            }
            case 23: {
                return '\u0014';
            }
            case 20: {
                return '\u0015';
            }
            case 21: {
                return '\u0016';
            }
            case 22: {
                return '\u0017';
            }
            case 29: {
                return '\u0018';
            }
            case 30: {
                return '\u0019';
            }
            case 24: {
                return '\u001a';
            }
            case 25: {
                return '\u001b';
            }
            case 26: {
                return '\u001c';
            }
            case 27: {
                return '\u001d';
            }
            case 28: {
                return '\u001e';
            }
        }
        return '\u0011';
    }

    public char classOfNext() {
        char c;
        if (this.curr_line.charAt(this.colPos - 1) == '\\' && this.curr_line.charAt(this.colPos) == 'u' && this.isHex(this.curr_line.charAt(this.colPos + 1)) && this.isHex(this.curr_line.charAt(this.colPos + 2)) && this.isHex(this.curr_line.charAt(this.colPos + 3)) && this.isHex(this.curr_line.charAt(this.colPos + 4))) {
            int n = (((this.unHex(this.curr_line.charAt(this.colPos + 1)) << 4) + this.unHex(this.curr_line.charAt(this.colPos + 2)) << 4) + this.unHex(this.curr_line.charAt(this.colPos + 3)) << 4) + this.unHex(this.curr_line.charAt(this.colPos + 4));
            c = (char)n;
            this.nextchar();
            this.nextchar();
            this.nextchar();
            this.nextchar();
            this.nextchar();
        } else {
            c = this.curr_line.charAt(this.colPos - 1);
        }
        return this.javaTypeOfToCharacterClass(Character.getType(c));
    }

    public int positionOfNext() {
        return this.curr_line_offset + this.colPos - 1;
    }

    public int positionOfMark() {
        if (!this.report_pos) {
            return -1;
        }
        int n = this.markLn < 0 ? this.positionOfNext() : (this.markLn >= this.line_breaks.size() ? this.markCol : this.line_breaks.get(this.markLn) + this.markCol);
        return n;
    }

    public int mark() {
        this.markLn = this.lnNum == -1 ? 0 : this.lnNum;
        this.markCol = this.colPos;
        return this.markCol;
    }

    public String copyWithoutInterpretingEscapedChars() {
        return this.curr_line.substring(this.markCol - 1, this.colPos);
    }

    public String escapeString(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n2 + 1;
        boolean bl = false;
        for (int i = n; i < n3; ++i) {
            if (stringBuffer.charAt(i) != '\\') continue;
            bl = true;
            break;
        }
        if (!bl) {
            return stringBuffer.substring(n, n3);
        }
        StringBuffer stringBuffer2 = new StringBuffer(n3 - n);
        block15: for (int i = n; i < n3; ++i) {
            int n4 = stringBuffer.charAt(i);
            if (n4 == 92) {
                char c = stringBuffer.charAt(i + 1);
                block0 : switch (c) {
                    case '\"': 
                    case '\'': {
                        continue block15;
                    }
                    case '\\': {
                        n4 = 92;
                        ++i;
                        break;
                    }
                    case 'u': {
                        int n5;
                        int n6;
                        int n7 = 0;
                        for (n6 = i + 2; n6 < i + 6 && n6 < n2 + 1 && (n5 = Character.digit(stringBuffer.charAt(n6), 16)) != -1; ++n6) {
                            n7 = (n7 << 4) + n5;
                        }
                        if (n6 != i + 6 || !Character.isDefined((char)n7)) {
                            n4 = stringBuffer.charAt(++i);
                            break;
                        }
                        n4 = (char)n7;
                        i += 5;
                        break;
                    }
                    default: {
                        if (Features.PASS_ESCAPES_TO_BACKEND) {
                            n4 = stringBuffer.charAt(++i);
                            break;
                        }
                        switch (c) {
                            case 'b': {
                                n4 = 8;
                                ++i;
                                break block0;
                            }
                            case 'f': {
                                n4 = 12;
                                ++i;
                                break block0;
                            }
                            case 'n': {
                                n4 = 10;
                                ++i;
                                break block0;
                            }
                            case 'r': {
                                n4 = 13;
                                ++i;
                                break block0;
                            }
                            case 't': {
                                n4 = 9;
                                ++i;
                                break block0;
                            }
                            case 'v': {
                                n4 = 11;
                                ++i;
                                break block0;
                            }
                            case 'x': {
                                if (i + 3 < this.colPos && this.isHex(stringBuffer.charAt(i + 2)) && this.isHex(stringBuffer.charAt(i + 3))) {
                                    n4 = (char)((this.unHex(stringBuffer.charAt(i + 2)) << 4) + this.unHex(stringBuffer.charAt(i + 3)));
                                    i += 3;
                                    break block0;
                                }
                                ++i;
                                n4 = 120;
                                break block0;
                            }
                        }
                        n4 = stringBuffer.charAt(++i);
                    }
                }
            }
            stringBuffer2.append((char)n4);
        }
        return stringBuffer2.toString();
    }

    public String copy() {
        return this.escapeString(this.curr_line, this.markCol - 1, this.colPos - 1);
    }

    public String getLineText(int n) {
        int n2;
        int n3;
        int n4;
        for (int i = 0; i < this.line_breaks.size() && (n4 = this.line_breaks.get(i)) <= n && n4 >= 0 && i <= this.lnNum; ++i) {
        }
        int n5 = this.text.length();
        for (n3 = n2 = this.line_breaks.get(i - 1); n3 < n5 && this.text.charAt(n3) != '\n' && this.text.charAt(n3) != '\r' && this.text.charAt(n3) != '\u0000'; ++n3) {
        }
        int n6 = n3 - n2;
        String string = n2 + n6 > this.text.length() ? this.text.substring(n2) : this.text.substring(n2, n2 + n6);
        return string;
    }

    public int getLineBreakPos(int n) {
        return this.line_breaks.at(n - 1);
    }

    public int getColPos(int n) {
        int n2 = this.getLnNum(n);
        return n - (n2 == 0 ? 0 : this.line_breaks.get(n2 - 1)) + 1;
    }

    public int getColPos(int n, int n2) {
        return n - (n2 == 0 ? 0 : this.line_breaks.get(n2 - 1)) + 1;
    }

    public void getLnNumAndColPos(int n, int[] nArray, int[] nArray2) {
        nArray[0] = this.getLnNum(n);
        nArray2[0] = n - (nArray[0] == 0 ? 0 : this.line_breaks.get(nArray[0] - 1)) + 1;
    }

    public int getLnNum(int n) {
        int n2 = 0;
        int n3 = this.lnNum;
        while (n3 >= n2) {
            int n4 = (n3 + n2) / 2;
            int n5 = this.line_breaks.get(n4);
            if (n5 > n) {
                n3 = n4;
                continue;
            }
            if (n5 == n) {
                return n4 + 1;
            }
            if (n4 == this.lnNum) {
                if (n > n5) {
                    return n4 + 1;
                }
                return n4;
            }
            if (this.line_breaks.size() == n4 + 1 || this.line_breaks.get(n4 + 1) > n) {
                return n4 + 1;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    public static String getLinePointer(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(".");
        }
        stringBuffer.append("^");
        return stringBuffer.toString();
    }

    public void clearUnusedBuffers() {
        this.text = new StringBuffer(this.text.toString());
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = null;
        this.curr_line = null;
        this.prev_line = null;
        this.bom = null;
    }
}

