/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InvalidStepException.java 4063 2009-06-18 08:15:08Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api;

import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean.Step;

/**
 * Exception thrown when the current operation is not in the expected step.
 * 
 * @author Arda Aydin
 * @author Malek Chahine
 * @author S. Ali Tokmen
 */
public class InvalidStepException extends JadortServiceException {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = 8949263403079331175L;

    private static String buildError(final Step currentStep, final Step... expectedSteps) {
        StringBuilder sb = new StringBuilder("That method should only be called when step is ");
        for (int i = 0; i < expectedSteps.length; i++) {
            if (i == expectedSteps.length - 1) {
                sb.append(" or ");
            } else if (i != 0) {
                sb.append(", ");
            }
            sb.append(expectedSteps[i]);
        }
        sb.append(". Currently, step is " + currentStep + ".");

        return sb.toString();
    }

    /**
     * Exception thrown when the current operation is not in the expected step.
     * 
     * @param currentStep The current step.
     * @param expectedSteps The steps that are allowed.
     */
    public InvalidStepException(final Step currentStep, final Step... expectedSteps) {
        super(InvalidStepException.buildError(currentStep, expectedSteps), null);
    }

}
