/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerBeanTest.java 4103 2009-06-19 19:05:14Z ardaaydin $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;

/**
 * Tests the ServerBean class.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class ServerBeanTest {

    private ServerBean server;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        this.server = new ServerBean();
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
        this.server = null;
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getId()}.
     */
    @Test
    public void testGetSetId() {
        Integer id = (int) (Math.random() * 100);

        Assert.assertNull(this.server.getId());
        this.server.setId(id);
        Assert.assertEquals(this.server.getId(), id);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getName()}
     * .
     */
    @Test
    public void testGetSetName() {
        Assert.assertNull(this.server.getName());

        String name = this.getClass().getSimpleName() + '#' + UUID.randomUUID();
        this.server.setName(name);
        Assert.assertEquals(name, this.server.getName());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getCapacity()}
     * .
     */
    @Test
    public void testGetSetCapacity() {
        Assert.assertEquals(0, this.server.getCapacity());

        int capacity = 100;
        this.server.setCapacity(capacity);
        Assert.assertEquals(capacity, this.server.getCapacity());

        try {
            this.server.setCapacity(-1);
        } catch (IllegalArgumentException ignored) {
            // Ignored
        }
        Assert.assertEquals(capacity, this.server.getCapacity());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getServerConnector()}
     * .
     */
    @Test
    public void testGetSetServerConnector() {
        Assert.assertNull(this.server.getServerConnector());

        ConnectorBean connector = new ConnectorBean();
        connector.setId(new Integer((int) (Math.random() * 100)));
        this.server.setServerConnector(connector);
        Assert.assertEquals(connector, this.server.getServerConnector());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getManagerConnector()}
     * .
     */
    @Test
    public void testGetSetManagerConnector() {
        Assert.assertNull(this.server.getManagerConnector());

        ConnectorBean connector = new ConnectorBean();
        connector.setId(new Integer((int) (Math.random() * 100)));
        this.server.setManagerConnector(connector);
        Assert.assertEquals(connector, this.server.getManagerConnector());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getActiveSessions()}
     * .
     */
    @Test
    public void testGetSetActiveSessions() {
        Assert.assertEquals(0, this.server.getActiveSessions());

        int sessions = 100;
        this.server.setActiveSessions(sessions);
        Assert.assertEquals(sessions, this.server.getActiveSessions());

        try {
            this.server.setActiveSessions(-1);
        } catch (IllegalArgumentException ignored) {
            // Ignored
        }
        Assert.assertEquals(sessions, this.server.getActiveSessions());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getProcessed()}
     * .
     */
    @Test
    public void testGetSetProcessed() {
        Assert.assertEquals(false, this.server.getProcessed());

        this.server.setProcessed(true);
        Assert.assertEquals(true, this.server.getProcessed());

        this.server.setProcessed(false);
        Assert.assertEquals(false, this.server.getProcessed());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getType()}
     * .
     */
    @Test
    public void testGetSetType() {
        Assert.assertNull(this.server.getType());

        for (ServerBean.Type type : ServerBean.Type.values()) {
            this.server.setType(type);
            Assert.assertEquals(type, this.server.getType());
        }
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getTarget()}
     * .
     */
    @Test
    public void testGetSetTarget() {
        Integer id = (int) (Math.random() * 100);
        Assert.assertNull(this.server.getTarget());

        ServerBean target = new ServerBean();
        target.setId(id);

        this.server.setTarget(target);
        Assert.assertEquals(target, this.server.getTarget());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getVm()} .
     */
    @Test
    public void testGetSetVm() {
        Integer id = (int) (Math.random() * 100);
        Assert.assertNull(this.server.getVm());

        VMBean vm = new VMBean();
        vm.setId(id);

        this.server.setVm(vm);
        Assert.assertEquals(vm, this.server.getVm());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#getApplications()}
     * .
     */
    @Test
    public void testGetSetApplications() {
        Assert.assertNotNull(this.server.getApplications());
        Assert.assertEquals(this.server.getApplications().size(), 0);

        List<ApplicationBean> applications = new ArrayList<ApplicationBean>();

        this.server.setApplications(applications);
        Assert.assertEquals(applications, this.server.getApplications());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#equals(Object)}
     * .
     */
    @Test
    public void testEquals() {
        Integer id1 = (int) (Math.random() * 100);
        Integer id2 = (int) (Math.random() * 100);
        while (id1.equals(id2)) {
            id2 = (int) (Math.random() * 100);
        }

        ServerBean bean1 = new ServerBean();
        ServerBean bean2 = new ServerBean();

        // Both identifiers are null
        Assert.assertFalse(bean1.equals(bean2));

        // bean2.getId() is null
        bean1.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        // bean1.getId() is null
        bean1.setId(null);
        bean2.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id1);
        Assert.assertEquals(bean1, bean2);

        bean1.setId(id1);
        bean2.setId(id2);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id2);
        bean2.setId(id2);
        Assert.assertEquals(bean1, bean2);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ServerBean#toString()}
     * .
     */
    @Test
    public void testToString() {
        Assert.assertNotNull(this.server.toString());
        Assert.assertFalse(this.server.toString().contains(this.server.getClass().getName()));
    }
}
