/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: 
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.business {

    import com.adobe.cairngorm.business.ServiceLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;

    public class SelectVMImageDelegate extends AbsDelegateResponder {

        public function selectVMImage(vmImage : VMImageVO) : void {

            // Find service
            var service : Object = ServiceLocator.getInstance().getRemoteObject("JadortServiceClient");

            // Call service
            var serviceResult : Object = service.selectVMImage(vmImage);

            // Add responder
            serviceResult.addResponder(this.responder);
        }

        public function selectVMImageForServer(vmImage : VMImageVO, server : ServerVO) : void {

            // Find service
            var service : Object = ServiceLocator.getInstance().getRemoteObject("JadortServiceClient");

            // Call service
            var serviceResult : Object = service.selectVMImage(vmImage, server);

            // Add responder
            serviceResult.addResponder(this.responder);
        }
    }

}