/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProgressStateEvent.as 3529 2009-04-23 11:49:00Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.event {

    /**
     * This event is used to update the global progress engine on the top panel of the UI.
     */
    public class ProgressStateEvent extends JadortEvent {

        /**
         * Name of the Event.
         */
        public static const EVENT_PROGRESS_STATE : String = "progressState";

        private var _oldIndex : Number;
        private var _newIndex : Number;

        public function ProgressStateEvent(oldIndex : Number, newIndex : Number) {
            super(ProgressStateEvent.EVENT_PROGRESS_STATE);

            this._oldIndex = oldIndex;
            this._newIndex = newIndex;
        }

        public function get oldIndex() : Number {
            return this._oldIndex;
        }

        public function get newIndex() : Number {
            return this._newIndex;
        }
    }
}
