/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GroupBeanTest.java 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;

/**
 * Tests the GroupBean class.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class GroupBeanTest {

    private GroupBean group;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        this.group = new GroupBean();
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
        this.group = null;
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#getId()}.
     */
    @Test
    public void testGetSetId() {
        Integer id = (int) (Math.random() * 100);

        Assert.assertNull(this.group.getId());
        this.group.setId(id);
        Assert.assertEquals(this.group.getId(), id);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#getName()}.
     */
    @Test
    public void testGetSetName() {
        Assert.assertNull(this.group.getName());

        String name = this.getClass().getSimpleName() + '#' + UUID.randomUUID();

        this.group.setName(name);
        Assert.assertEquals(name, this.group.getName());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#getClustered()}
     * .
     */
    @Test
    public void testGetSetClustered() {
        Assert.assertFalse(this.group.getClustered());

        this.group.setClustered(true);
        Assert.assertTrue(this.group.getClustered());

        this.group.setClustered(false);
        Assert.assertFalse(this.group.getClustered());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#getServers()}
     * .
     */
    @Test
    public void testGetSetServers() {
        Assert.assertNotNull(this.group.getServers());
        Assert.assertEquals(this.group.getServers().size(), 0);

        List<ServerBean> servers = new ArrayList<ServerBean>();

        this.group.setServers(servers);
        Assert.assertEquals(servers, this.group.getServers());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#getWorkers()}
     * .
     */
    @Test
    public void testGetSetWorkers() {
        Assert.assertNotNull(this.group.getWorkers());
        Assert.assertEquals(this.group.getWorkers().size(), 0);

        List<WorkerBean> workers = new ArrayList<WorkerBean>();

        this.group.setWorkers(workers);
        Assert.assertEquals(workers, this.group.getWorkers());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#getApplications()}
     * .
     */
    @Test
    public void testGetSetApplications() {
        Assert.assertNotNull(this.group.getApplications());
        Assert.assertEquals(this.group.getApplications().size(), 0);

        List<ApplicationBean> applications = new ArrayList<ApplicationBean>();

        this.group.setApplications(applications);
        Assert.assertEquals(applications, this.group.getApplications());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#equals(Object)}
     * .
     */
    @Test
    public void testEquals() {
        Integer id1 = (int) (Math.random() * 100);
        Integer id2 = (int) (Math.random() * 100);
        while (id1.equals(id2)) {
            id2 = (int) (Math.random() * 100);
        }

        GroupBean bean1 = new GroupBean();
        GroupBean bean2 = new GroupBean();

        // Both identifiers are null
        Assert.assertFalse(bean1.equals(bean2));

        // bean2.getId() is null
        bean1.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        // bean1.getId() is null
        bean1.setId(null);
        bean2.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id1);
        Assert.assertEquals(bean1, bean2);

        bean1.setId(id1);
        bean2.setId(id2);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id2);
        bean2.setId(id2);
        Assert.assertEquals(bean1, bean2);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.GroupBean#toString()}
     * .
     */
    @Test
    public void testToString() {
        Assert.assertNotNull(this.group.toString());
        Assert.assertFalse(this.group.toString().contains(this.group.getClass().getName()));
    }
}
