/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CheckWorkerCommand.as 3500 2009-04-22 13:57:09Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.command {

    import com.adobe.cairngorm.commands.*;
    import com.adobe.cairngorm.control.*;
    import mx.controls.*;
    import mx.rpc.IResponder;
    import mx.rpc.events.FaultEvent;
    import mx.rpc.events.ResultEvent;
    import org.ow2.jasmine.jadort.client.flex.business.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.*;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import org.ow2.jasmine.jadort.client.flex.view.*;
    import mx.events.*;
    import mx.controls.Alert;

    /**
     * This class checks if no problem on the worker and all problems are resolved on the worker.
     */
    public class CheckWorkerCommand extends SequenceCommandWithErrorHandling implements IResponder {

        private var worker : WorkerVO;

        override public function execute(event : CairngormEvent) : void {
            // cast the cairngorm event so we can get at the worker to be checked
            var checkWorkerEvent : CheckWorkerEvent = event as CheckWorkerEvent;
            worker = checkWorkerEvent.worker;
            var delegate : CheckWorkerDelegate = JadortModelLocator.getInstance().checkWorkerDelegate;
            delegate.responder = this;

            // delegate to the CheckWorkerDelegate to call the check worker service
            delegate.checkWorker(checkWorkerEvent.worker);
        }

        public function result(event : Object) : void {
            // Boolean value is contained in the event -> the problem worker is resolved
            // and it can be ignored and false if the problem still exists
            var resultEvent : ResultEvent = event as ResultEvent;
            var isOK : Boolean = resultEvent.result as Boolean;

            // Gets the Model
            var model : JadortModelLocator = JadortModelLocator.getInstance();

            // if the check worker Service returns true we dispatch the IgnoreWorker event to ignore the worker
            // if it returns false an alert box will display to inform the user that the problem still
            // and ask him if he is sure to ignore worker
            if (isOK) {
                super.nextEvent = new IgnoreWorkerEvent(worker);
                executeNextCommand();
            } else {
                CustomAlert.confirm("After check, it still seems like the problem has not been resolved!\nAre you sure you want to ignore worker?", ignoreWorker);
            }
        }

        /**
         * This function dispatch the IgnoreWorker Event if the user click
         * to yes button in the alert box.
         */
        private function ignoreWorker(event : CloseEvent) : void {
            if (event.detail == Alert.YES) {
                super.nextEvent = new IgnoreWorkerEvent(worker);
                executeNextCommand();
            }
        }
    }
}
