/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SelectGroupActionOperationRenderClass.as 4310 2009-07-07 14:41:06Z chahinem $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.events.*;
    import mx.containers.VBox;
    import mx.controls.*;
    import mx.controls.dataGridClasses.DataGridListData;
    import mx.controls.listClasses.BaseListData;
    import mx.events.*;
    import mx.managers.*;
    import org.ow2.jasmine.jadort.client.flex.event.SelectGroupEvent;
    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import com.adobe.cairngorm.control.CairngormEventDispatcher;
    import mx.collections.ArrayCollection;

    public class SelectGroupActionOperationRenderClass extends VBox {

        public var selectGroupButton : Button;

        private var _listData : DataGridListData;

        [Bindable]
        public var group : GroupVO;

        [Bindable]
        public var model : JadortModelLocator = JadortModelLocator.getInstance();

        public function set listData(value : BaseListData) : void {
            _listData = DataGridListData(value);
        }

        override public function set data(value : Object) : void {
            super.data = value;
            if (super.data != null) {
                selectGroupButton.enabled = super.data.connected
            }
        }
        
        public function get listData() : BaseListData {
            return _listData;
        }

        public function selectGroup(event : Event) : void {
            model.selectedGroup = super.data as GroupVO;
            var selectGroupEvent : SelectGroupEvent = new SelectGroupEvent(model.selectedGroup);
            CairngormEventDispatcher.getInstance().dispatchEvent(selectGroupEvent);
        }

    }

}