/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.config.flex.Adapter;
import org.granite.messaging.service.security.DestinationSecurizer;
import org.granite.util.ClassUtil;
import org.granite.util.JDOMUtil;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Destination
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SECURIZER_PROPERTY_KEY = "securizer";
    private final String id;
    private final List<String> channelRefs;
    private final Map<String, Serializable> properties;
    private final List<String> roles;
    private final Adapter adapter;
    private final DestinationSecurizer securizer;

    public Destination(String id, List<String> channelRefs, Map<String, Serializable> properties, List<String> roles, Adapter adapter) {
        this.id = id;
        this.channelRefs = Collections.unmodifiableList(channelRefs);
        this.properties = Collections.unmodifiableMap(properties);
        this.roles = roles != null ? Collections.unmodifiableList(roles) : null;
        this.adapter = adapter;
        String securizerClassName = (String)((Object)properties.get(SECURIZER_PROPERTY_KEY));
        if (securizerClassName != null) {
            try {
                this.securizer = ClassUtil.newInstance(securizerClassName.trim(), DestinationSecurizer.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate securizer: " + securizerClassName, e);
            }
        } else {
            this.securizer = null;
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getChannelRefs() {
        return this.channelRefs;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public boolean isSecured() {
        return this.roles != null;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public DestinationSecurizer getSecurizer() {
        return this.securizer;
    }

    public static Destination forElement(Element element, Adapter defaultAdapter, Map<String, Adapter> adaptersMap) {
        Element adapter;
        JDOMUtil.checkElement(element, "destination", "id");
        String id = element.getAttributeValue("id");
        ArrayList<String> channelRefs = new ArrayList<String>();
        Element channels = element.getChild("channels");
        if (channels != null) {
            for (Element channel : JDOMUtil.getChildren(channels, "channel")) {
                JDOMUtil.checkElement(channel, "channel", "ref");
                channelRefs.add(channel.getAttributeValue("ref"));
            }
        }
        HashMap<String, Serializable> propertiesMap = new HashMap<String, Serializable>();
        Element properties = element.getChild("properties");
        if (properties != null) {
            for (Element property : JDOMUtil.getChildren(properties)) {
                if (property.getChildren().size() == 0 && property.getText() != null && property.getText().trim().length() > 0) {
                    propertiesMap.put(property.getName(), (Serializable)((Object)property.getText()));
                    continue;
                }
                for (Element subproperty : JDOMUtil.getChildren(property)) {
                    for (Element prop : JDOMUtil.getChildren(subproperty, "property")) {
                        String name = prop.getChildText("name");
                        String value = prop.getChildText("value");
                        if (name == null || name.trim().length() <= 0 || value == null || value.trim().length() <= 0) continue;
                        propertiesMap.put(String.valueOf(property.getName()) + "." + subproperty.getName() + "." + prop.getName() + "." + name, (Serializable)((Object)value));
                    }
                    if (subproperty.getText() == null || subproperty.getText().trim().length() <= 0) continue;
                    propertiesMap.put(String.valueOf(property.getName()) + "." + subproperty.getName(), (Serializable)((Object)subproperty.getText()));
                }
            }
        }
        ArrayList<String> rolesList = null;
        Element security = element.getChild("security");
        if (security != null) {
            Element roles;
            rolesList = new ArrayList<String>();
            Element securityConstraint = security.getChild("security-constraint");
            if (securityConstraint != null && (roles = securityConstraint.getChild("roles")) != null) {
                for (Element role : JDOMUtil.getChildren(roles, "role")) {
                    rolesList.add(role.getValue());
                }
            }
        }
        Adapter adapterRef = (adapter = element.getChild("adapter")) != null && adapter.getAttributeValue("ref") != null && adaptersMap != null ? adaptersMap.get(adapter.getAttributeValue("ref")) : defaultAdapter;
        return new Destination(id, channelRefs, propertiesMap, rolesList, adapterRef);
    }
}

