/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.RemotingMessage;
import java.util.Collections;
import java.util.Map;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.SimpleServiceInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleServiceFactory
extends ServiceFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        String scope = (String)((Object)destination.getProperties().get("scope"));
        Map<String, Object> cache = null;
        if (scope == null || "request".equals(scope)) {
            cache = context.getRequestMap();
        } else if ("session".equals(scope)) {
            cache = context.getSessionMap();
        } else if ("application".equals(scope)) {
            cache = Collections.synchronizedMap(context.getApplicationMap());
        } else {
            throw new ServiceException("Illegal scope in destination: " + destination);
        }
        String key = String.valueOf(SimpleServiceInvoker.class.getName()) + '.' + destination.getId();
        SimpleServiceInvoker service = (SimpleServiceInvoker)cache.get(key);
        if (service == null) {
            service = new SimpleServiceInvoker(destination, this);
            cache.put(key, service);
        }
        return service;
    }
}

