/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class ArgumentListNode
extends Node {
    public ObjectList<Node> items = new ObjectList(1);
    public ObjectList<TypeInfo> expected_types;
    public ByteList decl_styles;

    public ArgumentListNode(Node node, int n) {
        super(n);
        this.items.add(node);
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public int size() {
        return this.items.size();
    }

    public int pos() {
        return this.items.size() != 0 ? this.items.last().pos() : 0;
    }

    public boolean isLiteralInteger() {
        return this.items.size() == 1 && this.items.first().isLiteralInteger();
    }

    public String toString() {
        return "ArgumentList";
    }

    public void addType(TypeInfo typeInfo) {
        if (this.expected_types == null) {
            this.expected_types = new ObjectList(2);
        }
        this.expected_types.push_back(typeInfo);
    }

    public void addDeclStyle(int n) {
        if (this.decl_styles == null) {
            this.decl_styles = new ByteList(2);
        }
        this.decl_styles.push_back((byte)n);
    }

    public boolean hasSideEffect() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.hasSideEffect()) continue;
            return true;
        }
        return false;
    }
}

