/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DummyMessage.java 3691 2009-05-12 20:15:19Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

/**
 * Dummy JMS message.
 * 
 * @author S. Ali Tokmen
 */
public class DummyMessage implements Message {

    private Map<String, Boolean> boolProperties = new HashMap<String, Boolean>();

    private Map<String, Integer> intProperties = new HashMap<String, Integer>();

    private Map<String, String> stringProperties = new HashMap<String, String>();

    public void acknowledge() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void clearBody() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void clearProperties() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public boolean getBooleanProperty(final String arg0) throws JMSException {
        return this.boolProperties.get(arg0);
    }

    public byte getByteProperty(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public double getDoubleProperty(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public float getFloatProperty(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public int getIntProperty(final String arg0) throws JMSException {
        return this.intProperties.get(arg0);
    }

    public String getJMSCorrelationID() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public int getJMSDeliveryMode() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public Destination getJMSDestination() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public long getJMSExpiration() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public String getJMSMessageID() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public int getJMSPriority() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public boolean getJMSRedelivered() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public Destination getJMSReplyTo() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public long getJMSTimestamp() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public String getJMSType() throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public long getLongProperty(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public Object getObjectProperty(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    @SuppressWarnings("unchecked")
    public Enumeration getPropertyNames() throws JMSException {
        List<String> propertyNames = new ArrayList<String>();
        propertyNames.addAll(this.boolProperties.keySet());
        propertyNames.addAll(this.intProperties.keySet());
        propertyNames.addAll(this.stringProperties.keySet());

        StringBuilder sb = new StringBuilder();
        for (String propertyName : propertyNames) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(propertyName);
        }
        return new StringTokenizer(sb.toString());
    }

    public short getShortProperty(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public String getStringProperty(final String arg0) throws JMSException {
        return this.stringProperties.get(arg0);
    }

    public boolean propertyExists(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setBooleanProperty(final String arg0, final boolean arg1) throws JMSException {
        this.boolProperties.put(arg0, arg1);
    }

    public void setByteProperty(final String arg0, final byte arg1) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setDoubleProperty(final String arg0, final double arg1) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setFloatProperty(final String arg0, final float arg1) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setIntProperty(final String arg0, final int arg1) throws JMSException {
        this.intProperties.put(arg0, arg1);
    }

    public void setJMSCorrelationID(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSCorrelationIDAsBytes(final byte[] arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSDeliveryMode(final int arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSDestination(final Destination arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSExpiration(final long arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSMessageID(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSPriority(final int arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSRedelivered(final boolean arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSReplyTo(final Destination arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSTimestamp(final long arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setJMSType(final String arg0) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setLongProperty(final String arg0, final long arg1) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setObjectProperty(final String arg0, final Object arg1) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setShortProperty(final String arg0, final short arg1) throws JMSException {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public void setStringProperty(final String arg0, final String arg1) throws JMSException {
        this.stringProperties.put(arg0, arg1);
    }
}
