/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GroupVO.as 4310 2009-07-07 14:41:06Z chahinem $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.vo {

    import com.adobe.cairngorm.vo.IValueObject;
    import mx.collections.ArrayCollection;
    import mx.controls.*;

    [RemoteClass(alias = "org.ow2.jasmine.jadort.api.entities.topology.GroupBean")]
    [Bindable]
    public class GroupVO implements IValueObject {

        [ArrayElementType(WorkerVO)]
        private var groupWorkers : ArrayCollection;

        [ArrayElementType(ServerVO)]
        private var groupServers : ArrayCollection;

        [ArrayElementType(ApplicationVO)]
        private var groupApplications : ArrayCollection;

        [ArrayElementType(VMImageVO)]
         private var groupVMImages : ArrayCollection;
        

        private var groupId : Number;
        private var groupMode : Number;
        private var groupName : String;
        private var groupConnected : Boolean;
        private var groupClustered : Boolean;

        public function GroupVO() {
            super();
        }

        public function get id() : Number {
            return groupId;
        }

        public function get workers() : ArrayCollection {
            return groupWorkers;
        }

        public function get name() : String {
            return groupName;
        }

        public function get servers() : ArrayCollection {
            return groupServers;
        }

        public function get applications() : ArrayCollection {
            return groupApplications;
        }

        public function get vmImages() : ArrayCollection {
            return groupVMImages;
        }

        public function get clustered() : Boolean {
            return groupClustered;
        }
        
        public function get connected() : Boolean {
            return groupConnected;
        }

        public function set id(groupId : Number) : void {
            this.groupId = groupId;
        }

        public function set servers(groupServers : ArrayCollection) : void {
            this.groupServers = groupServers;
        }

        public function set workers(groupWorkers : ArrayCollection) : void {
            this.groupWorkers = groupWorkers;
        }

        public function set name(groupName : String) : void {
            this.groupName = groupName;
        }

        public function set clustered(groupClustered : Boolean) : void {
            this.groupClustered = groupClustered;
        }

        public function set connected(groupConnected : Boolean) : void {
            this.groupConnected = groupConnected;
        }
        
        public function set applications(groupApplications : ArrayCollection) : void {
            this.groupApplications = groupApplications;
        }

        public function set vmImages(groupVMImages : ArrayCollection) : void {
            this.groupVMImages = groupVMImages;
        }

        public function get serversName() : String {
            var gServerNames : String = "";

            for (var i : Number = 0;i<groupServers.length;i++) {
                if (i == 0) {
                    gServerNames = groupServers.getItemAt(i).name;
                } else {
                    gServerNames = gServerNames + "\n" + groupServers.getItemAt(i).name;
                }
            }

            return gServerNames;
        }

        public function get applicationsName() : String {
            var gApplicationsName : String = "";

            for (var i : Number = 0;i<groupApplications.length;i++) {
                if (applications.getItemAt(i).state == "Deployed") {
                    if (i == 0) {
                        gApplicationsName = groupApplications.getItemAt(i).toString();
                    } else {
                        gApplicationsName = gApplicationsName + "\n" + groupApplications.getItemAt(i).toString();
                    }
                }
            }

            return gApplicationsName;
        }

        public function get workersName() : String {
            var groupWorkersName : String = "";

            for (var i : Number = 0;i<groupWorkers.length;i++) {
                if (i == 0) {
                    groupWorkersName = groupWorkers.getItemAt(i).name;
                } else {
                    groupWorkersName = groupWorkersName + "\n" + groupWorkers.getItemAt(i).name;
                }
            }

            return groupWorkersName;
        }

        public function get hasVms() : Boolean {
            if (groupServers !=null && groupServers.length>0) {
                return groupServers.getItemAt(0).vm != null;
            } else {
                return false;
            }
        }
    }
}
