/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public final class IntList {
    private int[] a;
    private int size;

    public IntList(IntList intList) {
        this(intList.size());
        System.arraycopy(intList.a, 0, this.a, 0, intList.size());
        this.size = intList.size;
    }

    public IntList() {
        this(10);
    }

    public IntList(int n) {
        this.a = new int[n];
        this.size = 0;
    }

    public void add(int n) {
        this.resize();
        this.a[this.size++] = n;
    }

    public void push_back(int n) {
        this.add(n);
    }

    public void addAll(int[] nArray) {
        this.addAll(nArray, nArray.length);
    }

    public void addAll(IntList intList) {
        this.addAll(intList.a, intList.size);
    }

    private void addAll(int[] nArray, int n) {
        this.resize(this.size + n);
        System.arraycopy(nArray, 0, this.a, this.size, n);
        this.size += n;
    }

    public void set(int n, int n2) {
        this.resize();
        this.a[n] = n2;
        if (n >= this.size) {
            this.size = n + 1;
        }
    }

    public void resize(int n) {
        if (n > this.a.length) {
            int n2 = this.a.length * 3 / 2 + 1;
            if (n2 < n) {
                n2 = n;
            }
            int[] nArray = new int[n2];
            System.arraycopy(this.a, 0, nArray, 0, this.size);
            this.a = nArray;
        }
    }

    private void resize() {
        if (this.size == this.a.length) {
            this.resize(this.size * 3 / 2 + 1);
        }
    }

    public int get(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.a[n];
    }

    public int at(int n) {
        return this.get(n);
    }

    public int first() {
        return this.size == 0 ? 0 : this.a[0];
    }

    public int last() {
        return this.size == 0 ? 0 : this.a[this.size - 1];
    }

    public int back() {
        return this.last();
    }

    public int remove(int n) {
        int n2 = this.get(n);
        if (n != this.size - 1) {
            System.arraycopy(this.a, n + 1, this.a, n, this.size - 1 - n);
        }
        --this.size;
        return n2;
    }

    public int removeLast() {
        return this.size == 0 ? 0 : this.remove(this.size - 1);
    }

    public void remove(int n, int n2) {
        if (n == n2) {
            this.remove(n);
        } else if (n <= n2) {
            n = n < 0 ? 0 : n;
            n2 = n2 > this.size ? this.size : n2;
            int[] nArray = new int[this.size];
            System.arraycopy(this.a, 0, nArray, 0, n);
            System.arraycopy(this.a, n2, nArray, n, this.size - n2);
            this.a = nArray;
            this.size -= n2 - n;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int pop_back() {
        int n = this.get(this.size() - 1);
        this.remove(this.size() - 1);
        return n;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.a, 0, nArray, 0, this.size);
        return nArray;
    }
}

