/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectorBeanTest.java 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.util.UUID;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * Tests the JMXConnectorBean class.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class ConnectorBeanTest {

    private ConnectorBean connector;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        this.connector = new ConnectorBean();
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
        this.connector = null;
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean#getId()}
     * .
     */
    @Test
    public void testGetSetId() {
        Integer id = (int) (Math.random() * 100);

        Assert.assertNull(this.connector.getId());
        this.connector.setId(id);
        Assert.assertEquals(this.connector.getId(), id);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean#getConnectorUrl()}
     * .
     */
    @Test
    public void testGetSetConnectorUrl() {
        String connectorUrl = "URL#" + UUID.randomUUID();

        Assert.assertNull(this.connector.getConnectorUrl());
        this.connector.setConnectorUrl(connectorUrl);
        Assert.assertEquals(connectorUrl, this.connector.getConnectorUrl());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean#getUsername()}
     * .
     */
    @Test
    public void testGetSetUsername() {
        String username = "Username#" + UUID.randomUUID();

        Assert.assertNull(this.connector.getUsername());
        this.connector.setUsername(username);
        Assert.assertEquals(username, this.connector.getUsername());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean#getPassword()}
     * .
     */
    @Test
    public void testGetSetPassword() {
        String password = "Password#" + UUID.randomUUID();

        Assert.assertNull(this.connector.getPassword());
        this.connector.setPassword(password);
        Assert.assertEquals(password, this.connector.getPassword());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean#equals(Object)}
     * .
     */
    @Test
    public void testEquals() {
        Integer id1 = (int) (Math.random() * 100);
        Integer id2 = (int) (Math.random() * 100);
        while (id1.equals(id2)) {
            id2 = (int) (Math.random() * 100);
        }

        ConnectorBean bean1 = new ConnectorBean();
        ConnectorBean bean2 = new ConnectorBean();

        // Both identifiers are null
        Assert.assertFalse(bean1.equals(bean2));

        // bean2.getId() is null
        bean1.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        // bean1.getId() is null
        bean1.setId(null);
        bean2.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id1);
        Assert.assertEquals(bean1, bean2);

        bean1.setId(id1);
        bean2.setId(id2);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id2);
        bean2.setId(id2);
        Assert.assertEquals(bean1, bean2);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean#toString()}
     * .
     */
    @Test
    public void testToString() {
        Assert.assertNotNull(this.connector.toString());
        Assert.assertFalse(this.connector.toString().contains(this.connector.getClass().getName()));
    }
}
