/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SelectOperationTypeRenderClass.as 5127 2009-09-01 16:22:17Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.events.*;
    import mx.containers.TitleWindow;
    import mx.containers.VBox;
    import mx.controls.*;
    import mx.controls.dataGridClasses.DataGridListData;
    import mx.controls.listClasses.BaseListData;
    import mx.events.*;
    import mx.managers.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import com.adobe.cairngorm.control.CairngormEventDispatcher;
    import mx.collections.ArrayCollection;

    public class SelectOperationTypeRenderClass extends VBox {

        public var selectOperationTypeButton : Button;

        private var _listData : DataGridListData;

        [Bindable]
        public var model : JadortModelLocator = JadortModelLocator.getInstance();

        public function SelectOperationTypeRenderClass() {
            // Empty constructor
            super();
        }

        public function set listData(value : BaseListData) : void {
            _listData = DataGridListData(value);
        }

        public function get listData() : BaseListData {
            return _listData;
        }

        override public function set data(value : Object) : void {
            super.data = value;
            if (super.data != null) {
                selectOperationTypeButton.label = super.data.action ;
            }
        }

        public function selectOperationType(event : Event) : void {
            var actionEvent: JadortEvent;
            if (super.data.action == "Maintain") {
                model.selectedServers = new ArrayCollection();
                model.servers = super.data.servers;
                actionEvent = new MaintainEvent();
            } else if (super.data.action == "Migrate") {
                model.selectedServers = super.data.servers;
                actionEvent = new MigrateEvent();
            } else {
                throw new Error("Unknown action type: " + super.data.action);
            }
            CairngormEventDispatcher.getInstance().dispatchEvent(actionEvent);
        }
    }
}
