/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerWorkerProgressbarItemRendererClass.as 3189 2009-03-20 17:40:43Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view
{
    import mx.controls.*;
    import flash.events.*;

    import mx.collections.ArrayCollection;
    import mx.containers.HBox;
    import mx.controls.*;
    import mx.controls.dataGridClasses.DataGridListData;
    import mx.controls.listClasses.BaseListData;

    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;

    public class ServerWorkerProgressbarItemRendererClass extends HBox
    {
        public var progressBar : ProgressBar;
        private var _listData : DataGridListData;

        public function ServerWorkerProgressbarItemRendererClass()
        {
            super();
        }

        public function set listData(value : BaseListData) : void
        {
            _listData = DataGridListData(value);
        }

        public function get listData() : BaseListData
        {
            return _listData;
        }

        override public function set data(value : Object) : void {
            super.data = value;
            if (super.data.state == "Error !") {
                progressBar.setStyle("themeColor", "#ff1a1a");
            } else {
                progressBar.setStyle("themeColor", "#009dff");
            }
            progressBar.setProgress(super.data.progress, 100);
            progressBar.label = "%3%%"; 
        }

        override public function get data() : Object {
            return super.data;
        }
    }
}
