/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpServletRequestParamWrapper
extends HttpServletRequestWrapper {
    Map requestParams;

    public HttpServletRequestParamWrapper(HttpServletRequest request) {
        super(request);
        this.requestParams = new HashMap(request.getParameterMap());
    }

    public String getParameter(String name) {
        String retValue = null;
        String[] paramValues = this.getParameterValues(name);
        if (paramValues != null && paramValues.length > 0) {
            retValue = paramValues[0];
        }
        return retValue;
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.requestParams);
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.requestParams.keySet());
    }

    public String[] getParameterValues(String name) {
        String[] retValues = null;
        String[] tmpValues = (String[])this.requestParams.get(name);
        if (tmpValues != null) {
            retValues = new String[tmpValues.length];
            System.arraycopy(tmpValues, 0, retValues, 0, tmpValues.length);
        }
        return retValues;
    }

    public void setParameter(String name, String value) {
        String[] param = new String[]{value};
        this.setParameter(name, param);
    }

    public void setParameter(String name, String[] values) {
        this.requestParams.put(name, values);
    }
}

