/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SelectVMImageActionOperationRenderClass.as 5127 2009-09-01 16:22:17Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.events.*;
    import mx.containers.TitleWindow;
    import mx.containers.VBox;
    import mx.controls.*;
    import mx.controls.dataGridClasses.DataGridListData;
    import mx.controls.listClasses.BaseListData;
    import mx.events.*;
    import mx.managers.*;
    import mx.collections.ArrayCollection;
    import com.adobe.cairngorm.control.CairngormEventDispatcher;
    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import org.ow2.jasmine.jadort.client.flex.event.SelectVMImageEvent;
    import mx.controls.Alert;
    
    public class SelectVMImageActionOperationRenderClass extends VBox {

        public var selectVMImageButton : Button;
    
        private var _listData : DataGridListData;

        [Bindable]
        public var vmImage : VMImageVO;

        [Bindable]
        public var model : JadortModelLocator = JadortModelLocator.getInstance();

        public function SelectVMImageActionOperationRenderClass() {
            // Empty constructor
            super();
        }

        public function set listData(value : BaseListData) : void {
            _listData = DataGridListData(value);
        }

        public function get listData() : BaseListData {
            return _listData;
        }

        public function selectVMImage(event : Event) : void {
            var selectedVmImage : VMImageVO = super.data as VMImageVO;
            var selectVMImageEvent : SelectVMImageEvent = new SelectVMImageEvent(selectedVmImage);
            CairngormEventDispatcher.getInstance().dispatchEvent(selectVMImageEvent);
        }
    }
}
