/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ModProxyBalancerTest.java 5638 2009-11-24 17:24:39Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.tests.action.modProxyBalancer;

import java.io.BufferedReader;
import java.io.FileReader;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Balancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.ModProxyBalancer;

/**
 * Tests the mod_proxy_balancer manager.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class ModProxyBalancerTest {

    private ModProxyBalancer modProxyBalancer;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        this.modProxyBalancer = new ModProxyBalancer("jkManagerUrl");
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
        this.modProxyBalancer = null;
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.service.action.modProxyBalancer.ModProxyBalancer#ParseAndUpdateModProxyBalancer(String)}
     * with the new mod_proxy_balancer output format (no nonce).<br/>
     * <br/>
     * That's the output for Apache HTTP Server before 2.2.9 (details are on the
     * http://httpd.apache.org/security/vulnerabilities_22.html page)
     */
    @Test
    public void testParseAndUpdateModProxyBalancerWithoutNonce() throws Exception {
        this.modProxyBalancer.parseAndUpdateModProxyBalancer(this
            .readFileAsString("src/test/resources/mod_proxy_balancer/HTMLResponse_no_nonce.html"));

        Assert.assertEquals(2, this.modProxyBalancer.balancers.size());
        Assert.assertNull(this.modProxyBalancer.nonce);

        Balancer balancer = this.modProxyBalancer.balancers.get(0);
        Assert.assertEquals("loadbalancer1", balancer.getName());
        Assert.assertEquals(2, balancer.getWorkers().size());
        Assert.assertEquals("http://localhost:8080/", balancer.getWorkers().get(0).getUrl());
        Assert.assertFalse(balancer.getWorkers().get(0).isEnabled());
        Assert.assertEquals("http://localhost:18080/", balancer.getWorkers().get(1).getUrl());
        Assert.assertTrue(balancer.getWorkers().get(1).isEnabled());

        balancer = this.modProxyBalancer.balancers.get(1);
        Assert.assertEquals("loadbalancer2", balancer.getName());
        Assert.assertEquals(2, balancer.getWorkers().size());
        Assert.assertEquals("http://localhost:28080/", balancer.getWorkers().get(0).getUrl());
        Assert.assertTrue(balancer.getWorkers().get(0).isEnabled());
        Assert.assertEquals("http://localhost:38080/", balancer.getWorkers().get(1).getUrl());
        Assert.assertTrue(balancer.getWorkers().get(1).isEnabled());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.service.action.modProxyBalancer.ModProxyBalancer#ParseAndUpdateModProxyBalancer(String)}
     * with the new mod_proxy_balancer output format (has nonce).<br/>
     * <br/>
     * That's the output for Apache HTTP Server starting 2.2.9 (details are on
     * the http://httpd.apache.org/security/vulnerabilities_22.html page)
     */
    @Test
    public void testParseAndUpdateModProxyBalancerWithNonce() throws Exception {
        this.modProxyBalancer.parseAndUpdateModProxyBalancer(this
            .readFileAsString("src/test/resources/mod_proxy_balancer/HTMLResponse_with_nonce.html"));

        Assert.assertEquals(2, this.modProxyBalancer.balancers.size());
        Assert.assertEquals("565067fa-7271-b24d-bbb4-6266708d125a", this.modProxyBalancer.nonce);

        Balancer balancer = this.modProxyBalancer.balancers.get(0);
        Assert.assertEquals("loadbalancer1", balancer.getName());
        Assert.assertEquals(2, balancer.getWorkers().size());
        Assert.assertEquals("http://localhost:8080/", balancer.getWorkers().get(0).getUrl());
        Assert.assertFalse(balancer.getWorkers().get(0).isEnabled());
        Assert.assertEquals("http://localhost:18080/", balancer.getWorkers().get(1).getUrl());
        Assert.assertTrue(balancer.getWorkers().get(1).isEnabled());

        balancer = this.modProxyBalancer.balancers.get(1);
        Assert.assertEquals("loadbalancer2", balancer.getName());
        Assert.assertEquals(2, balancer.getWorkers().size());
        Assert.assertEquals("http://localhost:28080/", balancer.getWorkers().get(0).getUrl());
        Assert.assertTrue(balancer.getWorkers().get(0).isEnabled());
        Assert.assertEquals("http://localhost:38080/", balancer.getWorkers().get(1).getUrl());
        Assert.assertTrue(balancer.getWorkers().get(1).isEnabled());
    }

    private String readFileAsString(final String filePath) throws java.io.IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

}
