/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkerBeanTest.java 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.topology;

import java.util.UUID;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * Tests the WorkerBean class.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class WorkerBeanTest {

    private WorkerBean worker;

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
        this.worker = new WorkerBean();
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
        this.worker = null;
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#getId()}.
     */
    @Test
    public void testGetSetId() {
        Integer id = (int) (Math.random() * 100);

        Assert.assertNull(this.worker.getId());
        this.worker.setId(id);
        Assert.assertEquals(this.worker.getId(), id);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#getName()}
     * .
     */
    @Test
    public void testGetSetName() {
        String name = this.getClass().getSimpleName() + '#' + UUID.randomUUID();
        this.worker.setName(name);

        Assert.assertEquals(name, this.worker.getName());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#getServerName()}
     * .
     */
    @Test
    public void testGetSetServerName() {
        String name = "Server#" + UUID.randomUUID();
        this.worker.setServerName(name);

        Assert.assertEquals(name, this.worker.getServerName());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#getWorkerName()}
     * .
     */
    @Test
    public void testGetSetWorkerName() {
        String name = "Worker#" + UUID.randomUUID();
        this.worker.setWorkerName(name);

        Assert.assertEquals(name, this.worker.getWorkerName());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#getConnector()}
     * .
     */
    @Test
    public void testGetSetConnector() {
        Assert.assertNull(this.worker.getConnector());

        ConnectorBean connector = new ConnectorBean();
        connector.setId(new Integer((int) (Math.random() * 100)));
        this.worker.setConnector(connector);

        Assert.assertEquals(connector, this.worker.getConnector());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#getServer()}
     * .
     */
    @Test
    public void testGetSetServer() {
        Assert.assertNull(this.worker.getServer());

        ServerBean server = new ServerBean();
        server.setId(new Integer((int) (Math.random() * 100)));
        this.worker.setServer(server);

        Assert.assertEquals(server, this.worker.getServer());
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#getType()}
     * .
     */
    @Test
    public void testGetSetType() {
        Assert.assertNull(this.worker.getType());

        for (WorkerBean.Type type : WorkerBean.Type.values()) {
            this.worker.setType(type);
            Assert.assertEquals(type, this.worker.getType());
        }
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#equals(Object)}
     * .
     */
    @Test
    public void testEquals() {
        Integer id1 = (int) (Math.random() * 100);
        Integer id2 = (int) (Math.random() * 100);
        while (id1.equals(id2)) {
            id2 = (int) (Math.random() * 100);
        }

        WorkerBean bean1 = new WorkerBean();
        WorkerBean bean2 = new WorkerBean();

        // Both identifiers are null
        Assert.assertFalse(bean1.equals(bean2));

        // bean2.getId() is null
        bean1.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        // bean1.getId() is null
        bean1.setId(null);
        bean2.setId(id1);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id1);
        Assert.assertEquals(bean1, bean2);

        bean1.setId(id1);
        bean2.setId(id2);
        Assert.assertFalse(bean1.equals(bean2));

        bean1.setId(id2);
        bean2.setId(id2);
        Assert.assertEquals(bean1, bean2);
    }

    /**
     * Test method for
     * {@link org.ow2.jasmine.jadort.api.entities.topology.WorkerBean#toString()}
     * .
     */
    @Test
    public void testToString() {
        Assert.assertNotNull(this.worker.toString());
        Assert.assertFalse(this.worker.toString().contains(this.worker.getClass().getName()));
    }
}
