/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.Message;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.granite.util.StringUtil;
import org.granite.util.UUIDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Message {
    private Object body = null;
    private Object clientId = null;
    private String destination = null;
    private Map<String, Object> headers = null;
    private String messageId = null;
    private long timestamp = 0L;
    private long timeToLive = 0L;

    public AbstractMessage() {
    }

    public AbstractMessage(Message request) {
        this.messageId = UUIDUtil.randomUUID();
        this.timestamp = System.currentTimeMillis();
        this.clientId = UUIDUtil.randomUUID();
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    @Override
    public void setBody(Object body) {
        this.body = body;
    }

    @Override
    public Object getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(Object clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    @Override
    public Object getHeader(String name) {
        return this.headers != null ? this.headers.get(name) : null;
    }

    @Override
    public boolean headerExists(String name) {
        return this.headers != null ? this.headers.containsKey(name) : false;
    }

    @Override
    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(name, value);
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    protected void toString(StringBuilder sb, String indent, String bodyAlternative) {
        sb.append('\n').append(indent).append("  destination = ").append(this.destination);
        if (this.headers != null && this.headers.containsKey("DSRemoteCredentials")) {
            HashMap<String, Object> headersCopy = new HashMap<String, Object>(this.headers);
            headersCopy.put("DSRemoteCredentials", "****** (credentials)");
            sb.append('\n').append(indent).append("  headers = ").append(headersCopy);
        } else {
            sb.append('\n').append(indent).append("  headers = ").append(this.headers);
        }
        sb.append('\n').append(indent).append("  messageId = ").append(this.messageId);
        sb.append('\n').append(indent).append("  timestamp = ").append(this.timestamp);
        sb.append('\n').append(indent).append("  clientId = ").append(this.clientId);
        sb.append('\n').append(indent).append("  timeToLive = ").append(this.timeToLive);
        sb.append('\n').append(indent).append("  body = ").append(AbstractMessage.printBody(this.body, bodyAlternative));
    }

    private static String printBody(Object body, String bodyAlternative) {
        Object object = body = bodyAlternative != null ? bodyAlternative : body;
        if (body == null) {
            return null;
        }
        if (body.getClass().isArray() || body instanceof Collection || body instanceof Map) {
            return StringUtil.toString(body, 100);
        }
        return body.toString();
    }
}

