/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.AsyncMessage;

public class CommandMessage
extends AsyncMessage {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR_HEADER = "DSSelector";
    public static final int SUBSCRIBE_OPERATION = 0;
    public static final int UNSUBSCRIBE_OPERATION = 1;
    public static final int POLL_OPERATION = 2;
    public static final int CLIENT_SYNC_OPERATION = 4;
    public static final int CLIENT_PING_OPERATION = 5;
    public static final int CLUSTER_REQUEST_OPERATION = 7;
    public static final int LOGIN_OPERATION = 8;
    public static final int LOGOUT_OPERATION = 9;
    public static final int SESSION_INVALIDATE_OPERATION = 10;
    public static final int UNKNOWN_OPERATION = 10000;
    public static final int CONNECT_OPERATION = 20;
    public static final int DISCONNECT_OPERATION = 21;
    private String messageRefType;
    private int operation;

    public String getMessageRefType() {
        return this.messageRefType;
    }

    public void setMessageRefType(String messageRefType) {
        this.messageRefType = messageRefType;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public boolean isSecurityOperation() {
        return this.isLoginOperation() || this.isLogoutOperation();
    }

    public boolean isLoginOperation() {
        return this.operation == 8;
    }

    public boolean isLogoutOperation() {
        return this.operation == 9;
    }

    public boolean isClientPingOperation() {
        return this.operation == 5;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getClass().getName()).append(" {");
        sb.append('\n').append(indent).append("  messageRefType: ").append(this.messageRefType);
        sb.append('\n').append(indent).append("  operation: ").append(CommandMessage.getReadableOperation(this.operation));
        super.toString(sb, indent, this.isLoginOperation() ? "****** (credentials)" : null);
        sb.append('\n').append(indent).append('}');
        return sb.toString();
    }

    private static String getReadableOperation(int operation) {
        switch (operation) {
            case 0: {
                return "SUBSCRIBE";
            }
            case 1: {
                return "UNSUBSCRIBE";
            }
            case 2: {
                return "POLL";
            }
            case 4: {
                return "CLIENT_SYNC";
            }
            case 5: {
                return "CLIENT_PING";
            }
            case 7: {
                return "CLUSTER_REQUEST";
            }
            case 8: {
                return "LOGIN";
            }
            case 9: {
                return "LOGOUT";
            }
            case 10: {
                return "SESSION_INVALIDATE";
            }
            case 10000: {
                return "UNKNOWN";
            }
            case 20: {
                return "CONNECT";
            }
            case 21: {
                return "DISCONNECT";
            }
        }
        return "REALLY UNKNOWN: 0x" + Integer.toBinaryString(operation);
    }
}

