/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.granite.config.flex.EndPoint;
import org.granite.util.JDOMUtil;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel {
    private static final String LEGACY_XML = "legacy-xml";
    private static final String LEGACY_COLLECTION = "legacy-collection";
    private final String id;
    private final String className;
    private final EndPoint endPoint;
    private final Map<String, String> serializationProperties;
    private final boolean legacyXml;
    private final boolean legacyCollection;

    public Channel(String id, String className, EndPoint endPoint, Map<String, String> properties) {
        this.id = id;
        this.className = className;
        this.endPoint = endPoint;
        this.serializationProperties = Collections.unmodifiableMap(properties);
        this.legacyCollection = "true".equals(this.serializationProperties.get(LEGACY_COLLECTION));
        this.legacyXml = "true".equals(this.serializationProperties.get(LEGACY_XML));
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public Map<String, String> getSerializationProperties() {
        return this.serializationProperties;
    }

    public boolean isLegacyXmlSerialization() {
        return this.legacyXml;
    }

    public boolean isLegacyCollectionSerialization() {
        return this.legacyCollection;
    }

    public static Channel forElement(Element element) {
        Element serialization;
        JDOMUtil.checkElement(element, "channel-definition", "id", "class");
        String id = element.getAttributeValue("id");
        String className = element.getAttributeValue("class");
        Element endPointElt = element.getChild("endpoint");
        if (endPointElt == null) {
            throw new RuntimeException("Excepting a 'endpoint' element in 'channel-definition': " + id);
        }
        EndPoint endPoint = EndPoint.forElement(endPointElt);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Element properties = element.getChild("properties");
        if (properties != null && (serialization = properties.getChild("serialization")) != null) {
            for (Element property : JDOMUtil.getChildren(serialization)) {
                if (property.getChildren().size() != 0 || property.getText() == null || property.getText().trim().length() <= 0) continue;
                propertiesMap.put(property.getName(), property.getText());
            }
        }
        return new Channel(id, className, endPoint, propertiesMap);
    }
}

