/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.util.JDOMUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesConfig {
    private static final String SERVICES_CONFIG_KEY = String.valueOf(ServicesConfig.class.getName()) + "_CACHE";
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Map<String, Factory> factories = new HashMap<String, Factory>();

    public static ServicesConfig getConfig(ServletContext context) {
        return (ServicesConfig)context.getAttribute(SERVICES_CONFIG_KEY);
    }

    public static synchronized ServicesConfig loadConfig(ServletContext context) throws ServletException {
        InputStream is;
        ServicesConfig servicesConfig = (ServicesConfig)context.getAttribute(SERVICES_CONFIG_KEY);
        if (servicesConfig != null) {
            return servicesConfig;
        }
        String path = context.getInitParameter("servicesConfigPath");
        if (path == null) {
            path = "/WEB-INF/flex/services-config.xml";
        }
        if ((is = context.getResourceAsStream(path)) == null) {
            throw new ServletException("Could not load: " + path + " (file does not exists)");
        }
        try {
            return ServicesConfig.loadConfig(is);
        }
        catch (Exception e) {
            throw new ServletException("Could not load custom granite-config.xml", (Throwable)e);
        }
    }

    public Service findServiceById(String id) {
        return this.services.get(id);
    }

    public Channel findChannelById(String id) {
        return this.channels.get(id);
    }

    public Factory findFactoryById(String id) {
        return this.factories.get(id);
    }

    public Destination findDestinationById(String messageType, String id) {
        for (Service service : this.services.values()) {
            Destination destination;
            if (messageType != null && !messageType.equals(service.getMessageTypes()) || (destination = service.findDestinationById(id)) == null) continue;
            return destination;
        }
        return null;
    }

    public List<Destination> findDestinationsByMessageType(String messageType) {
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        for (Service service : this.services.values()) {
            if (!messageType.equals(service.getMessageTypes())) continue;
            destinations.addAll(service.getDestinations().values());
        }
        return destinations;
    }

    public List<Service> findServicesByMessageType(String messageType) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service service : services) {
            if (!messageType.equals(service.getMessageTypes())) continue;
            services.add(service);
        }
        return services;
    }

    public void addService(Service service) {
        this.services.put(service.getId(), service);
    }

    public void addChannel(Channel channel) {
        this.channels.put(channel.getId(), channel);
    }

    public void addFactory(Factory factory) {
        this.factories.put(factory.getId(), factory);
    }

    public static ServicesConfig forElement(Element element) {
        Element factories;
        Element channels;
        JDOMUtil.checkElement(element, "services-config", new String[0]);
        ServicesConfig config = new ServicesConfig();
        Element services = element.getChild("services");
        if (services != null) {
            for (Element service : JDOMUtil.getChildren(services, "service")) {
                Service serv = Service.forElement(service);
                config.services.put(serv.getId(), serv);
            }
        }
        if ((channels = element.getChild("channels")) != null) {
            for (Element channel : JDOMUtil.getChildren(channels, "channel-definition")) {
                Channel chan = Channel.forElement(channel);
                config.channels.put(chan.getId(), chan);
            }
        }
        if ((factories = element.getChild("factories")) != null) {
            for (Element factory : JDOMUtil.getChildren(factories, "factory")) {
                Factory fact = Factory.forElement(factory);
                config.factories.put(fact.getId(), fact);
            }
        }
        return config;
    }

    public static ServicesConfig loadConfig(InputStream servicesis) throws IOException, JDOMException {
        Document doc = JDOMUtil.readDocument(servicesis);
        return ServicesConfig.forElement(doc.getRootElement());
    }
}

