/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.granite.config.flex.Destination;
import org.granite.logging.Logger;
import org.granite.messaging.service.EjbServiceFactory;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceInvoker
extends ServiceInvoker<EjbServiceFactory> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(EjbServiceInvoker.class);
    public static final String CAPITALIZED_DESTINATION_ID = "{capitalized.destination.id}";
    public static final String DESTINATION_ID = "{destination.id}";

    public EjbServiceInvoker(Destination destination, EjbServiceFactory factory) throws ServiceException {
        super(destination, factory);
        String lookup = factory.getLookup();
        if (destination.getProperties().containsKey("lookup")) {
            lookup = (String)((Object)destination.getProperties().get("lookup"));
        }
        String name = destination.getId();
        if (lookup != null) {
            name = lookup;
            if (lookup.contains(CAPITALIZED_DESTINATION_ID)) {
                name = lookup.replace(CAPITALIZED_DESTINATION_ID, this.capitalize(destination.getId()));
            }
            if (lookup.contains(DESTINATION_ID)) {
                name = lookup.replace(DESTINATION_ID, destination.getId());
            }
        }
        InitialContext ic = null;
        try {
            ic = new InitialContext();
        }
        catch (Exception e) {
            throw new ServiceException("Could not get InitialContext", e);
        }
        log.debug(">> New EjbServiceInvoker looking up: %s", name);
        try {
            this.invokee = ic.lookup(name);
        }
        catch (NamingException e) {
            throw new ServiceException("Could not lookup for: " + name, e);
        }
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }
}

