/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.granite.util.AtomicConverter;
import org.granite.util.ClassUtil;
import org.granite.util.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtil {
    public static final AtomicConverter<Object> NOOP_CONVERTER = new AtomicConverter<Object>(){

        @Override
        public Object convert(Object o) {
            return o;
        }
    };

    public static boolean isCollectionType(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || clazz.isArray();
    }

    public static int getCollectionLength(Object collection) {
        if (collection instanceof Collection) {
            return ((Collection)collection).size();
        }
        if (collection instanceof Map) {
            return ((Map)collection).size();
        }
        if (collection.getClass().isArray()) {
            return Array.getLength(collection);
        }
        return -1;
    }

    public static Type[] getComponentTypes(Type collectionType) {
        Type[] typeArray;
        Class<?> collectionClass = ClassUtil.classOfType(collectionType);
        if (!CollectionUtil.isCollectionType(collectionClass)) {
            return null;
        }
        if (collectionType instanceof GenericArrayType) {
            return new Type[]{((GenericArrayType)collectionType).getGenericComponentType()};
        }
        if (!collectionClass.isArray() && collectionType instanceof ParameterizedType) {
            Type[] argsType = ((ParameterizedType)collectionType).getActualTypeArguments();
            if (Collection.class.isAssignableFrom(collectionClass) && argsType.length >= 1) {
                Type[] typeArray2;
                if (argsType.length == 1) {
                    typeArray2 = argsType;
                } else {
                    Type[] typeArray3 = new Type[1];
                    typeArray2 = typeArray3;
                    typeArray3[0] = argsType[0];
                }
                return typeArray2;
            }
            if (Map.class.isAssignableFrom(collectionClass) && argsType.length >= 1) {
                Type[] typeArray4;
                if (argsType.length == 2) {
                    typeArray4 = argsType;
                } else {
                    Type[] typeArray5 = new Type[2];
                    typeArray5[0] = argsType[0];
                    typeArray4 = typeArray5;
                    typeArray5[1] = argsType.length >= 2 ? argsType[1] : WildcardType.class;
                }
                return typeArray4;
            }
        }
        if (Map.class.isAssignableFrom(collectionClass)) {
            Type[] typeArray6 = new Type[2];
            typeArray6[0] = WildcardType.class;
            typeArray = typeArray6;
            typeArray6[1] = WildcardType.class;
        } else {
            Type[] typeArray7 = new Type[1];
            typeArray = typeArray7;
            typeArray7[0] = WildcardType.class;
        }
        return typeArray;
    }

    public static Object convert(Type targetType, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> targetClass = ClassUtil.classOfType(targetType);
        if (!CollectionUtil.isCollectionType(targetClass)) {
            return value;
        }
        Class<?> valueClass = value.getClass();
        if (!CollectionUtil.isCollectionType(valueClass)) {
            return value;
        }
        Type[] targetComponentTypes = CollectionUtil.getComponentTypes(targetType);
        if (targetComponentTypes == null) {
            return value;
        }
        if (!targetClass.isAssignableFrom(valueClass)) {
            Object newValue = CollectionUtil.newCollection(targetClass, targetComponentTypes, value);
            CollectionUtil.addAndConvertAll(newValue, value, targetComponentTypes);
            value = newValue;
        } else {
            CollectionUtil.convertAll(value, targetComponentTypes);
        }
        return value;
    }

    public static Object newCollection(Class<?> targetClass, Type[] targetComponentTypes, Object value) {
        int length = CollectionUtil.getCollectionLength(value);
        if (targetClass.isArray()) {
            return Array.newInstance(ClassUtil.classOfType(targetComponentTypes[0]), length);
        }
        if (!targetClass.isInterface()) {
            try {
                return targetClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instanciate collection class: " + targetClass, e);
            }
        }
        if (Collection.class.isAssignableFrom(targetClass)) {
            if (Set.class.isAssignableFrom(targetClass)) {
                if (SortedSet.class.isAssignableFrom(targetClass)) {
                    return new TreeSet();
                }
                return new HashSet(length);
            }
            return new ArrayList(length);
        }
        if (Map.class.isAssignableFrom(targetClass)) {
            return new HashMap(length);
        }
        throw new IllegalArgumentException("Not a collection type: " + targetClass);
    }

    public static void convertAll(Object value, Type[] targetComponentTypes) {
        Class<?> secondTargetComponentClass;
        Class<?> valueClass = value.getClass();
        Class<?> firstTargetComponentClass = ClassUtil.classOfType(targetComponentTypes[0]);
        Class<?> clazz = secondTargetComponentClass = targetComponentTypes.length > 1 ? ClassUtil.classOfType(targetComponentTypes[1]) : null;
        if (Number.class.isAssignableFrom(firstTargetComponentClass) || secondTargetComponentClass != null && Number.class.isAssignableFrom(secondTargetComponentClass)) {
            AtomicConverter<Object> secondConverter;
            AtomicConverter<Object> firstConverter = NumberUtil.getNumberConverter(firstTargetComponentClass);
            if (firstConverter == null) {
                firstConverter = NOOP_CONVERTER;
            }
            if ((secondConverter = NumberUtil.getNumberConverter(secondTargetComponentClass)) == null) {
                secondConverter = NOOP_CONVERTER;
            }
            if (valueClass.isArray()) {
                int length = Array.getLength(value);
                int i = 0;
                while (i < length) {
                    Array.set(value, i, firstConverter.convert(Array.get(value, i)));
                    ++i;
                }
            } else if (Collection.class.isAssignableFrom(valueClass)) {
                if (List.class.isAssignableFrom(valueClass)) {
                    List list = (List)value;
                    int length = list.size();
                    int i = 0;
                    while (i < length) {
                        list.set(i, firstConverter.convert(list.get(i)));
                        ++i;
                    }
                } else {
                    Collection collection = (Collection)value;
                    Object[] values = collection.toArray(new Object[collection.size()]);
                    collection.clear();
                    Object[] objectArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        collection.add(firstConverter.convert(item));
                        ++n2;
                    }
                }
            } else if (Map.class.isAssignableFrom(valueClass)) {
                Map map = (Map)value;
                Map.Entry[] entries = (Map.Entry[])map.entrySet().toArray(new Object[map.size()]);
                map.clear();
                Map.Entry[] entryArray = entries;
                int n = entries.length;
                int n3 = 0;
                while (n3 < n) {
                    Map.Entry entry = entryArray[n3];
                    map.put(firstConverter.convert(entry.getKey()), secondConverter.convert(entry.getValue()));
                    ++n3;
                }
            } else {
                throw new IllegalArgumentException("value should be a collection: " + valueClass);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addAndConvertAll(Object newValue, Object value, Type[] targetComponentTypes) {
        Class<?> newValueClass = newValue.getClass();
        Class<?> valueClass = value.getClass();
        Class<?> firstTargetComponentClass = ClassUtil.classOfType(targetComponentTypes[0]);
        Class<?> secondTargetComponentClass = targetComponentTypes.length > 1 ? ClassUtil.classOfType(targetComponentTypes[1]) : null;
        AtomicConverter<Object> firstConverter = null;
        AtomicConverter<Object> secondConverter = null;
        if (Number.class.isAssignableFrom(firstTargetComponentClass) || secondTargetComponentClass != null && Number.class.isAssignableFrom(secondTargetComponentClass)) {
            firstConverter = NumberUtil.getNumberConverter(firstTargetComponentClass);
            secondConverter = NumberUtil.getNumberConverter(secondTargetComponentClass);
        }
        if (firstConverter == null) {
            firstConverter = NOOP_CONVERTER;
        }
        if (secondConverter == null) {
            secondConverter = NOOP_CONVERTER;
        }
        if (valueClass.isArray()) {
            int length = Array.getLength(value);
            if (newValueClass.isArray()) {
                int i = 0;
                while (i < length) {
                    Array.set(newValue, i, firstConverter.convert(Array.get(value, i)));
                    ++i;
                }
                return;
            } else if (Collection.class.isAssignableFrom(newValueClass)) {
                Collection collection = (Collection)newValue;
                int i = 0;
                while (i < length) {
                    collection.add(firstConverter.convert(Array.get(value, i)));
                    ++i;
                }
                return;
            } else {
                if (!Map.class.isAssignableFrom(newValueClass)) throw new IllegalArgumentException("newValue should be a collection: " + newValueClass);
                Map map = (Map)newValue;
                int i = 0;
                while (i < length) {
                    map.put(firstConverter.convert(Array.get(value, i)), null);
                    ++i;
                }
            }
            return;
        } else if (Collection.class.isAssignableFrom(valueClass)) {
            Collection collection = (Collection)value;
            int length = collection.size();
            if (newValueClass.isArray()) {
                Iterator iterator = collection.iterator();
                int i = 0;
                while (i < length) {
                    Array.set(newValue, i, firstConverter.convert(iterator.next()));
                    ++i;
                }
                return;
            } else if (Collection.class.isAssignableFrom(newValueClass)) {
                Collection newCollection = (Collection)newValue;
                for (Object item : collection) {
                    newCollection.add(firstConverter.convert(item));
                }
                return;
            } else {
                if (!Map.class.isAssignableFrom(newValueClass)) throw new IllegalArgumentException("newValue should be a collection: " + newValueClass);
                Map newMap = (Map)newValue;
                for (Object item : collection) {
                    newMap.put(firstConverter.convert(item), null);
                }
            }
            return;
        } else {
            if (!Map.class.isAssignableFrom(valueClass)) throw new IllegalArgumentException("value should be a collection: " + valueClass);
            Map map = (Map)value;
            int length = map.size();
            if (newValueClass.isArray()) {
                Iterator iterator = map.keySet().iterator();
                int i = 0;
                while (i < length) {
                    Array.set(newValue, i, firstConverter.convert(iterator.next()));
                    ++i;
                }
                return;
            } else if (Collection.class.isAssignableFrom(newValueClass)) {
                Collection newCollection = (Collection)newValue;
                for (Object item : map.keySet()) {
                    newCollection.add(firstConverter.convert(item));
                }
                return;
            } else {
                if (!Map.class.isAssignableFrom(newValueClass)) throw new IllegalArgumentException("newValue should be a collection: " + newValueClass);
                Map newMap = (Map)newValue;
                for (Map.Entry item : map.entrySet()) {
                    newMap.put(firstConverter.convert(item.getKey()), secondConverter.convert(item.getValue()));
                }
            }
        }
    }
}

