/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbortWorkerCommand.as 5127 2009-09-01 16:22:17Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.command {

    import mx.collections.ArrayCollection;
    import mx.rpc.IResponder;
    import mx.rpc.events.FaultEvent;
    import mx.rpc.events.ResultEvent;
    import org.ow2.jasmine.jadort.client.flex.business.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.*;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import com.adobe.cairngorm.control.*;

    /**
     * This class allows to force the worker to be aborted and continues this task
     */
    public class AbortWorkerCommand extends SequenceCommandWithErrorHandling implements IResponder {

        private var worker : WorkerVO;

        public function AbortWorkerCommand() {
            // Empty constructor
            super();
        }

        override public function execute(event : CairngormEvent) : void {
            // cast the cairngorm event so we can get at the worker to be aborted
            var abortWorkerEvent : AbortWorkerEvent = event as AbortWorkerEvent;
            worker = abortWorkerEvent.worker;
            var delegate : AbortWorkerDelegate = JadortModelLocator.getInstance().abortWorkerDelegate;
            delegate.responder = this;

            // delegate to the AbortWorkerDelegate to call the abort worker service
            delegate.abortWorker(abortWorkerEvent.worker);
        }

        public function result(event : Object) : void {
            super.nextEvent = new GetCurrentOperationEvent();
            executeNextCommand();
         }
    }
}
