/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LoadTopologyEvent.as 6153 2010-03-12 16:13:09Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.event {

    public class LoadTopologyEvent extends JadortEvent {

        /**
         * Name of the Event.
         */
        public static const EVENT_LOAD_TOPOLOGY : String = "loadTopology";

        // the topology XML
        private var _xmlTopology : String;

        /**
         * Default constructor.
         */
        public function LoadTopologyEvent(xmlTopology : String) {
            super(EVENT_LOAD_TOPOLOGY);
            this._xmlTopology = xmlTopology;
        }

        public function get xmlTopology() : String {
            return this._xmlTopology;
        }
    }

}