/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JadortControl.as 3500 2009-04-22 13:57:09Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.control
{
    import com.adobe.cairngorm.control.*;
    import org.ow2.jasmine.jadort.client.flex.command.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;

    public class JadortControl extends FrontController
    {
        public function JadortControl()
        {
            addCommand(AbortServerEvent.EVENT_ABORT_SERVER, AbortServerCommand);
            addCommand(RestartServerEvent.EVENT_RESTART_SERVER, RestartServerCommand);
            addCommand(CheckServerEvent.EVENT_CHECK_SERVER, CheckServerCommand);
            addCommand(IgnoreServerEvent.EVENT_FORCE_SERVER, IgnoreServerCommand);

            addCommand(AbortWorkerEvent.EVENT_ABORT_WORKER, AbortWorkerCommand);
            addCommand(RestartWorkerEvent.EVENT_RESTART_WORKER, RestartWorkerCommand);
            addCommand(CheckWorkerEvent.EVENT_CHECK_WORKER, CheckWorkerCommand);
            addCommand(IgnoreWorkerEvent.EVENT_FORCE_WORKER, IgnoreWorkerCommand);

            addCommand(CreateApplicationEvent.EVENT_CREATE_APPLICATION, CreateApplicationCommand);
            addCommand(CreateNewOperationEvent.EVENT_CREATE_NEW_OPERATION, CreateNewOperationCommand);
            addCommand(DeleteOperationEvent.EVENT_DELETE_OPERATION, DeleteOperationCommand);
            addCommand(GetCurrentOperationEvent.EVENT_GET_CURRENT_OPERATION, GetCurrentOperationCommand);
            addCommand(GetOperationsListEvent.EVENT_GET_OPERATIONS_LIST, GetOperationsListCommand);
            addCommand(GetPageIndexEvent.EVENT_GET_PAGE_INDEX, GetPageIndexCommand);
            addCommand(LoadTopologyEvent.EVENT_LOAD_TOPOLOGY, LoadTopologyCommand);
            addCommand(MaintainEvent.EVENT_MAINTAIN, MaintainCommand);
            addCommand(MigrateEvent.EVENT_MIGRTAE, MigrateCommand);
            addCommand(NextEvent.EVENT_NEXT, NextCommand);
            addCommand(PreviousEvent.EVENT_PREVIOUS, PreviousCommand);
            addCommand(SelectGroupEvent.EVENT_SELECT_GROUP, SelectGroupCommand);
            addCommand(SelectOperationEvent.EVENT_SELECT_OPERATION, SelectOperationCommand);
            addCommand(SelectServersEvent.EVENT_SELECT_SERVERS, SelectServersCommand);
            addCommand(SelectVMImageEvent.EVENT_SELECT_VM_IMAGE, SelectVMImageCommand);

            addCommand(InitializeEvent.EVENT_INITIALIZE, InitializeCommand);
        }
    }
}
