/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.ActionScriptClassDescriptorFactory;
import org.granite.config.ExternalizerFactory;
import org.granite.config.GraniteConfigException;
import org.granite.config.JavaClassDescriptorFactory;
import org.granite.config.TypeFactory;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.amf.io.util.ActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.Converter;
import org.granite.messaging.amf.io.util.DefaultClassGetter;
import org.granite.messaging.amf.io.util.DefaultConverter;
import org.granite.messaging.amf.io.util.JavaClassDescriptor;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.service.ServiceInvocationListener;
import org.granite.messaging.service.security.SecurityService;
import org.granite.util.ClassUtil;
import org.granite.util.JDOMUtil;
import org.granite.util.StreamUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraniteConfig {
    private static final Logger log = Logger.getLogger(GraniteConfig.class);
    private static final String GRANITE_CONFIG_PUBLIC_ID = "-//Granite Data Services//DTD granite-config internal//EN";
    private static final String GRANITE_CONFIG_KEY = String.valueOf(GraniteConfig.class.getName()) + "_CACHE";
    private static final ExternalizerFactory EXTERNALIZER_FACTORY = new ExternalizerFactory();
    private static final ActionScriptClassDescriptorFactory ASC_DESCRIPTOR_FACTORY = new ActionScriptClassDescriptorFactory();
    private static final JavaClassDescriptorFactory JC_DESCRIPTOR_FACTORY = new JavaClassDescriptorFactory();
    private SecurityService securityService = null;
    private ClassGetter classGetter = new DefaultClassGetter();
    private Converter converter = new DefaultConverter();
    private ServiceInvocationListener invocationListener = null;
    private Constructor<AMF3Serializer> amf3SerializerConstructor = null;
    private Constructor<AMF3Deserializer> amf3DeserializerConstructor = null;
    private final Map<String, String> instanciators = new HashMap<String, String>();
    private final ConcurrentHashMap<String, Externalizer> externalizersByType = new ConcurrentHashMap();
    private final Map<String, String> externalizersByInstanceOf = new HashMap<String, String>();
    private final Map<String, String> externalizersByAnnotatedWith = new HashMap<String, String>();
    private final ConcurrentHashMap<String, Class<? extends JavaClassDescriptor>> javaDescriptorsByType = new ConcurrentHashMap();
    private final Map<String, String> javaDescriptorsByInstanceOf = new HashMap<String, String>();
    private final ConcurrentHashMap<String, Class<? extends ActionScriptClassDescriptor>> as3DescriptorsByType = new ConcurrentHashMap();
    private final Map<String, String> as3DescriptorsByInstanceOf = new HashMap<String, String>();
    private Constructor<?> messageSelectorConstructor;

    public static GraniteConfig getConfig(ServletContext context) {
        return (GraniteConfig)context.getAttribute(GRANITE_CONFIG_KEY);
    }

    public static synchronized GraniteConfig loadConfig(ServletContext context) throws ServletException {
        InputStream is;
        GraniteConfig graniteConfig = (GraniteConfig)context.getAttribute(GRANITE_CONFIG_KEY);
        if (graniteConfig != null) {
            return graniteConfig;
        }
        String path = context.getInitParameter("graniteConfigPath");
        if (path == null) {
            path = "/WEB-INF/granite/granite-config.xml";
        }
        if ((is = context.getResourceAsStream(path)) == null) {
            log.warn("Could not load custom granite-config.xml: %s (file does not exists)", path);
            path = null;
        }
        try {
            return GraniteConfig.loadConfig(is);
        }
        catch (Exception e) {
            throw new ServletException("Could not load custom granite-config.xml", (Throwable)e);
        }
    }

    private GraniteConfig() {
        try {
            this.amf3SerializerConstructor = ClassUtil.getConstructor(AMF3Serializer.class, new Class[]{OutputStream.class});
            this.amf3DeserializerConstructor = ClassUtil.getConstructor(AMF3Deserializer.class, new Class[]{InputStream.class});
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not get constructor for AMF3 (de)serializers", e);
        }
    }

    public boolean hasSecurityService() {
        return this.securityService != null;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public ClassGetter getClassGetter() {
        return this.classGetter;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public ServiceInvocationListener getInvocationListener() {
        return this.invocationListener;
    }

    public ObjectOutput newAMF3Serializer(OutputStream out) {
        try {
            return this.amf3SerializerConstructor.newInstance(out);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not create serializer instance with: " + this.amf3SerializerConstructor, e);
        }
    }

    public ObjectInput newAMF3Deserializer(InputStream in) {
        try {
            return this.amf3DeserializerConstructor.newInstance(in);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not create deserializer instance with: " + this.amf3DeserializerConstructor, e);
        }
    }

    public Constructor<?> getMessageSelectorConstructor() {
        return this.messageSelectorConstructor;
    }

    public String getInstanciator(String type) {
        return this.instanciators.get(type);
    }

    public Externalizer getExternalizer(String type) {
        return this.getElementByType(type, EXTERNALIZER_FACTORY, this.externalizersByType, this.externalizersByInstanceOf, this.externalizersByAnnotatedWith);
    }

    public Class<? extends ActionScriptClassDescriptor> getActionScriptDescriptor(String type) {
        return this.getElementByType(type, ASC_DESCRIPTOR_FACTORY, this.as3DescriptorsByType, this.as3DescriptorsByInstanceOf, null);
    }

    public Class<? extends JavaClassDescriptor> getJavaDescriptor(String type) {
        return this.getElementByType(type, JC_DESCRIPTOR_FACTORY, this.javaDescriptorsByType, this.javaDescriptorsByInstanceOf, null);
    }

    private <T> T getElementByType(String type, TypeFactory<T> factory, ConcurrentHashMap<String, T> elementsByType, Map<String, String> elementsByInstanceOf, Map<String, String> elementsByAnnotatedWith) {
        T previous;
        T NULL = factory.getNullInstance();
        T element = elementsByType.get(type);
        if (element != null) {
            return NULL == element ? null : (T)element;
        }
        element = NULL;
        Class<?> typeClass = null;
        try {
            typeClass = ClassUtil.forName(type);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not load class: " + type, e);
        }
        for (Map.Entry<String, String> entry : elementsByInstanceOf.entrySet()) {
            String instanceOf = entry.getKey();
            try {
                Class<?> instanceOfClass = ClassUtil.forName(instanceOf);
                if (!instanceOfClass.isAssignableFrom(typeClass)) continue;
                element = factory.getInstance(entry.getValue());
                break;
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not load class: " + instanceOf, e);
            }
        }
        if (elementsByAnnotatedWith != null && NULL == element) {
            for (Map.Entry<String, String> entry : elementsByAnnotatedWith.entrySet()) {
                String annotation = entry.getKey();
                try {
                    Class<Annotation> annotationClass = ClassUtil.forName(annotation, Annotation.class);
                    if (!typeClass.isAnnotationPresent(annotationClass)) continue;
                    element = factory.getInstance(entry.getValue());
                    break;
                }
                catch (Exception e) {
                    throw new GraniteConfigException("Could not load class: " + annotation, e);
                }
            }
        }
        if ((previous = elementsByType.putIfAbsent(type, element)) != null) {
            element = previous;
        }
        return NULL == element ? null : (T)element;
    }

    private static GraniteConfig forElement(Element element) {
        return GraniteConfig.forElement(new GraniteConfig(), element);
    }

    private static GraniteConfig forElement(GraniteConfig config, Element element) {
        Element selector;
        String msg;
        Element security;
        String type;
        Element descriptors;
        Element externalizers;
        Element classGetter;
        Element instanciators;
        Element invocationListener;
        Element converter;
        Element amf3Deserializer;
        GraniteConfig.checkElement(element, "granite-config", new String[0]);
        Element amf3Serializer = element.getChild("amf3serializer");
        if (amf3Serializer != null) {
            GraniteConfig.checkElement(amf3Serializer, "amf3serializer", "type");
            String type2 = amf3Serializer.getAttributeValue("type");
            try {
                Class<AMF3Serializer> amf3SerializerClass = ClassUtil.forName(type2, AMF3Serializer.class);
                config.amf3SerializerConstructor = ClassUtil.getConstructor(amf3SerializerClass, new Class[]{OutputStream.class});
            }
            catch (Exception e) {
                String msg2 = "Could not get constructor for AMF3 serializer: " + type2;
                throw new GraniteConfigException(msg2, e);
            }
        }
        if ((amf3Deserializer = element.getChild("amf3deserializer")) != null) {
            GraniteConfig.checkElement(amf3Deserializer, "amf3deserializer", "type");
            String type3 = amf3Deserializer.getAttributeValue("type");
            try {
                Class<AMF3Deserializer> amf3DeserializerClass = ClassUtil.forName(type3, AMF3Deserializer.class);
                config.amf3DeserializerConstructor = ClassUtil.getConstructor(amf3DeserializerClass, new Class[]{InputStream.class});
            }
            catch (Exception e) {
                String msg3 = "Could not get constructor for AMF3 deserializer: " + type3;
                throw new GraniteConfigException(msg3, e);
            }
        }
        if ((converter = element.getChild("converter")) != null) {
            GraniteConfig.checkElement(converter, "converter", "type");
            String type4 = converter.getAttributeValue("type");
            try {
                config.converter = (Converter)ClassUtil.newInstance(type4);
            }
            catch (Exception e) {
                String msg4 = "Could not instantiate Converter: " + type4;
                throw new GraniteConfigException(msg4, e);
            }
        }
        if ((invocationListener = element.getChild("invocationlistener")) != null) {
            GraniteConfig.checkElement(invocationListener, "invocationlistener", "type");
            String type5 = invocationListener.getAttributeValue("type");
            try {
                config.invocationListener = (ServiceInvocationListener)ClassUtil.newInstance(type5);
            }
            catch (Exception e) {
                String msg5 = "Could not instantiate ServiceInvocationListener: " + type5;
                throw new GraniteConfigException(msg5, e);
            }
        }
        if ((instanciators = element.getChild("instanciators")) != null) {
            for (Element instanciator : JDOMUtil.getChildren(instanciators, "instanciator")) {
                GraniteConfig.checkElement(instanciator, "instanciator", "type");
                config.instanciators.put(instanciator.getAttributeValue("type"), instanciator.getText());
            }
        }
        if ((classGetter = element.getChild("classgetter")) != null) {
            GraniteConfig.checkElement(classGetter, "classgetter", "type");
            String type6 = classGetter.getAttributeValue("type");
            try {
                config.classGetter = (ClassGetter)ClassUtil.newInstance(type6);
            }
            catch (Exception e) {
                String msg6 = "Could not instantiate ClassGetter: " + type6;
                throw new GraniteConfigException(msg6, e);
            }
        }
        if ((externalizers = element.getChild("externalizers")) != null) {
            for (Element externalizer : JDOMUtil.getChildren(externalizers, "externalizer")) {
                GraniteConfig.checkElement(externalizer, "externalizer", "type");
                String externalizerType = externalizer.getAttributeValue("type");
                for (Element include : JDOMUtil.getChildren(externalizer, "include")) {
                    String type7 = include.getAttributeValue("type");
                    if (type7 != null) {
                        config.externalizersByType.put(type7, EXTERNALIZER_FACTORY.getInstance(externalizerType));
                        continue;
                    }
                    String instanceOf = include.getAttributeValue("instanceof");
                    if (instanceOf != null) {
                        config.externalizersByInstanceOf.put(instanceOf, externalizerType);
                        continue;
                    }
                    String annotatedWith = include.getAttributeValue("annotatedwith");
                    if (annotatedWith == null) {
                        String msg7 = "Element 'include' has no attribute 'type', 'instanceof' or 'annotatedwith'";
                        throw new GraniteConfigException(msg7);
                    }
                    config.externalizersByAnnotatedWith.put(annotatedWith, externalizerType);
                }
            }
        }
        if ((descriptors = element.getChild("descriptors")) != null) {
            for (Element descriptor : JDOMUtil.getChildren(descriptors, "descriptor")) {
                GraniteConfig.checkElement(descriptor, "descriptor", new String[0]);
                type = descriptor.getAttributeValue("type");
                if (type != null) {
                    String java = descriptor.getAttributeValue("java");
                    String as3 = descriptor.getAttributeValue("as3");
                    if (java == null && as3 == null) {
                        throw new GraniteConfigException("Element 'descriptor' has no attributes 'java' or 'as3'\n" + JDOMUtil.toString(descriptor));
                    }
                    if (java != null) {
                        config.javaDescriptorsByType.put(type, (Class<? extends JavaClassDescriptor>)JC_DESCRIPTOR_FACTORY.getInstance(java));
                    }
                    if (as3 == null) continue;
                    config.as3DescriptorsByType.put(type, (Class<? extends ActionScriptClassDescriptor>)ASC_DESCRIPTOR_FACTORY.getInstance(as3));
                    continue;
                }
                String instanceOf = descriptor.getAttributeValue("instanceof");
                if (instanceOf == null) {
                    throw new GraniteConfigException("Element 'descriptor' has no attribute 'type' or 'instanceof'\n" + JDOMUtil.toString(descriptor));
                }
                String java = descriptor.getAttributeValue("java");
                String as3 = descriptor.getAttributeValue("as3");
                if (java == null && as3 == null) {
                    String msg8 = "Element 'descriptor' has no attributes 'java' or 'as3' in:\n" + JDOMUtil.toString(descriptor);
                    throw new GraniteConfigException(msg8);
                }
                if (java != null) {
                    config.javaDescriptorsByInstanceOf.put(instanceOf, java);
                }
                if (as3 == null) continue;
                config.as3DescriptorsByInstanceOf.put(instanceOf, as3);
            }
        }
        if ((security = element.getChild("security")) != null) {
            GraniteConfig.checkElement(security, "security", "type");
            String type8 = security.getAttributeValue("type");
            try {
                config.securityService = (SecurityService)ClassUtil.newInstance(type8);
            }
            catch (Exception e) {
                String msg9 = "Could not instantiate SecurityService: " + type8;
                throw new GraniteConfigException(msg9, e);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            for (Element param : JDOMUtil.getChildren(security, "param")) {
                GraniteConfig.checkElement(param, "param", "name", "value");
                String name = param.getAttributeValue("name");
                String value = param.getAttributeValue("value");
                params.put(name, value);
            }
            try {
                config.securityService.configure(params);
            }
            catch (Exception e) {
                msg = "Could not configure SecurityService " + type8 + " with: " + params;
                throw new GraniteConfigException(msg, e);
            }
        }
        if ((selector = element.getChild("messageselector")) != null) {
            GraniteConfig.checkElement(selector, "messageselector", "type");
            type = selector.getAttributeValue("type");
            try {
                config.messageSelectorConstructor = ClassUtil.getConstructor(type, new Class[]{String.class});
            }
            catch (Exception e) {
                msg = "Could not construct message selector: " + type;
                throw new GraniteConfigException(msg, e);
            }
        }
        return config;
    }

    public static GraniteConfig loadConfig(InputStream configis) throws IOException, JDOMException {
        Document doc;
        GraniteConfig config = null;
        final ByteArrayInputStream dtd = StreamUtil.getResourceAsStream("org/granite/config/granite-config.dtd");
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (GraniteConfig.GRANITE_CONFIG_PUBLIC_ID.equals(publicId)) {
                    dtd.reset();
                    InputSource source = new InputSource(dtd);
                    source.setPublicId(publicId);
                    return source;
                }
                return null;
            }
        };
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/granite/config/granite-config.xml");
            doc = JDOMUtil.readDocument(is, resolver);
            config = GraniteConfig.forElement(doc.getRootElement());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (configis != null) {
            doc = JDOMUtil.readDocument(configis, resolver);
            config = GraniteConfig.forElement(config, doc.getRootElement());
        }
        return config;
    }

    private static void checkElement(Element element, String name, String ... attrs) {
        if (!element.getName().equals(name)) {
            throw new GraniteConfigException("Expected a '" + name + "' element in: " + element);
        }
        if (attrs != null) {
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (element.getAttribute(attr) == null) {
                    throw new GraniteConfigException("Element '" + name + "' has no attribute '" + attr + "' in:\n" + JDOMUtil.toString(element));
                }
                ++n2;
            }
        }
    }
}

