/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.granite.logging.DefaultLoggingFormatter;
import org.granite.logging.LoggingFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    private final org.apache.log4j.Logger log4jLogger;
    private final LoggingFormatter formatter;

    protected Logger(org.apache.log4j.Logger log4jLogger, LoggingFormatter formatter) {
        this.log4jLogger = log4jLogger;
        this.formatter = formatter;
    }

    public static Logger getLogger() {
        return Logger.getLogger(new DefaultLoggingFormatter());
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName(), (LoggingFormatter)new DefaultLoggingFormatter());
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name, (LoggingFormatter)new DefaultLoggingFormatter());
    }

    public static Logger getLogger(LoggingFormatter formatter) {
        Throwable t = new Throwable();
        StackTraceElement[] stes = t.getStackTrace();
        if (stes.length < 2) {
            throw new RuntimeException("Illegal instantiation context (stacktrace elements should be of length >= 2)", t);
        }
        return Logger.getLogger(stes[1].getClassName());
    }

    public static Logger getLogger(Class<?> clazz, LoggingFormatter formatter) {
        return Logger.getLogger(clazz.getName(), formatter);
    }

    public static Logger getLogger(String name, LoggingFormatter formatter) {
        return new Logger(LogManager.getLogger((String)name), formatter);
    }

    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.log4jLogger.info((Object)this.formatter.format(message, args));
        }
    }

    public void info(Throwable t, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.log4jLogger.info((Object)this.formatter.format(message, args), t);
        }
    }

    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.log4jLogger.trace((Object)this.formatter.format(message, args));
        }
    }

    public void trace(Throwable t, String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.log4jLogger.trace((Object)this.formatter.format(message, args), t);
        }
    }

    public void warn(String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.log4jLogger.warn((Object)this.formatter.format(message, args));
        }
    }

    public void warn(Throwable t, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.log4jLogger.warn((Object)this.formatter.format(message, args), t);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.log4jLogger.debug((Object)this.formatter.format(message, args));
        }
    }

    public void debug(Throwable t, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.log4jLogger.debug((Object)this.formatter.format(message, args), t);
        }
    }

    public void error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.log4jLogger.error((Object)this.formatter.format(message, args));
        }
    }

    public void error(Throwable t, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.log4jLogger.error((Object)this.formatter.format(message, args), t);
        }
    }

    public void fatal(String message, Object ... args) {
        if (this.isFatalEnabled()) {
            this.log4jLogger.fatal((Object)this.formatter.format(message, args));
        }
    }

    public void fatal(Throwable t, String message, Object ... args) {
        if (this.isFatalEnabled()) {
            this.log4jLogger.fatal((Object)this.formatter.format(message, args), t);
        }
    }

    public void setLevel(Level level) {
        this.log4jLogger.setLevel(level);
    }

    public boolean isDebugEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.TRACE);
    }

    public boolean isWarnEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.WARN);
    }
}

