/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ResumeDeleteOperationRenderClass.as 5127 2009-09-01 16:22:17Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.events.*;
    import flash.net.*;
    import flash.utils.Timer;
    import mx.containers.TitleWindow;
    import mx.containers.HBox;
    import mx.controls.*;
    import mx.controls.dataGridClasses.DataGridListData;
    import mx.controls.listClasses.BaseListData;
    import mx.events.*;
    import mx.managers.*;
    import mx.states.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import com.adobe.cairngorm.control.CairngormEventDispatcher;

    // ResumeDeleteOperationRenderClass Class allows to add the resume operation and delete operation in the action column of the operations table
    public class ResumeDeleteOperationRenderClass extends HBox {

        public var resumeButton : Button;
        private var _listData : DataGridListData;

        [Bindable]
        public var operation : OperationStateVO;

        [Bindable]
        public var model : JadortModelLocator = JadortModelLocator.getInstance();

        public function ResumeDeleteOperationRenderClass() {
            // Empty constructor
            super();
        }

        public function set listData(value : BaseListData) : void {
            _listData = DataGridListData(value);
        }

        public function get listData() : BaseListData {
            return _listData;
        }

        // lauch the resume command
        public function ResumeOperationButton(event : Event) : void {
            var operation : OperationStateVO = super.data as OperationStateVO;
            var selectOperationEvent : SelectOperationEvent = new SelectOperationEvent(operation);
            CairngormEventDispatcher.getInstance().dispatchEvent(selectOperationEvent);
        }

        // delete an operation
         public function DeleteOperationButton(event : Event) : void {
             CustomAlert.confirm("Are you sure you want to delete that operation?",deleteOperation);
        }

        // this function launch the deleteOperationEvent to delete an operation
         private function deleteOperation(event : CloseEvent) : void {
             var operation : OperationStateVO = super.data as OperationStateVO;
             if (event.detail == Alert.YES) {
                 var deleteOperationEvent : DeleteOperationEvent = new DeleteOperationEvent(operation);
                 CairngormEventDispatcher.getInstance().dispatchEvent(deleteOperationEvent);
             }
         }
     }

}