/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JadortModelLocator.as 3614 2009-05-04 16:52:50Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.model {

    import com.adobe.cairngorm.model.IModelLocator;
    import com.adobe.cairngorm.control.CairngormEventDispatcher;
    import mx.collections.ArrayCollection;
    import mx.controls.Alert;
    import org.ow2.jasmine.jadort.client.flex.business.*;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;

    /**
     * this class is the model locator of the application, we use it to store the client side model.
     *(it is implement the model in the Cairngorm Model-View-Controller architecture)
     */
    [Bindable]
    public class JadortModelLocator implements IModelLocator {

        private static var modelLocator : JadortModelLocator = null;

        // The ServerProgressVO and WorkerProgressVO ActionScript classes add
        // some attributes to their Java correspondents, and the Flash
        // on-the-fly compiler doesn't recompile the ActionScript classes if we
        // don't reference them. Put some private null references to avoid
        // weird bugs.
        private var dummyServerProgressVO : ServerProgressVO = null;
        private var dummyWorkerProgressVO : WorkerProgressVO = null;

        public var index : Number = 0;

        public var nextButtonEnabled : Boolean = false;
        public var previousButtonEnabled : Boolean = false;
        public var selectServerInfoDisplayed : Boolean = false;

        public var selectedGroup : GroupVO = null;
        public var uploadedApplication : ApplicationVO = null;
        public var currentOperation : OperationStateVO = null;
        public var selectedServer : ServerVO = null;

        [ArrayElementType(OperationStateVO)]
        public var operationsList : ArrayCollection = null;

        [ArrayElementType(ServerVO)]
        public var servers : ArrayCollection = null;

        [ArrayElementType(GroupVO)]
        public var groups : ArrayCollection = null;

        [ArrayElementType(ServerVO)]
        public var selectedServers : ArrayCollection = null;

        [ArrayElementType(ServerProgressVO)]
        public var serverProgressList : ArrayCollection = null;

        [ArrayElementType(WorkerProgressVO)]
        public var workerProgressList : ArrayCollection = null;

        public var totalActiveSessions : Number = 0;

        private var _getOperationsListDelegate : GetOperationsListDelegate = new GetOperationsListDelegate();

        private var _deleteOperationDelegate : DeleteOperationDelegate = new DeleteOperationDelegate();

        private var _selectOperationDelegate : SelectOperationDelegate = new SelectOperationDelegate();

        private var _createNewOperationDelegate : CreateNewOperationDelegate = new CreateNewOperationDelegate();

        private var _getCurrentOperationDelegate : GetCurrentOperationDelegate = new GetCurrentOperationDelegate();

        private var _getPageIndexDelegate : GetPageIndexDelegate = new GetPageIndexDelegate();

        private var _nextDelegate : NextDelegate = new NextDelegate();

        private var _previousDelegate : PreviousDelegate = new PreviousDelegate();

        private var _loadTopologyDelegate : LoadTopologyDelegate = new LoadTopologyDelegate();

        private var _selectGroupDelegate : SelectGroupDelegate = new SelectGroupDelegate();

        private var _selectServersDelegate : SelectServersDelegate = new SelectServersDelegate();

        private var _selectVMImageDelegate : SelectVMImageDelegate = new SelectVMImageDelegate();

        private var _maintainDelegate : MaintainDelegate = new MaintainDelegate();

        private var _migrateDelegate : MigrateDelegate = new MigrateDelegate();

        private var _selectApplicationDelegate : SelectApplicationDelegate = new SelectApplicationDelegate();

        private var _abortServerDelegate : AbortServerDelegate = new AbortServerDelegate();

        private var _restartServerDelegate : RestartServerDelegate = new RestartServerDelegate();

        private var _checkServerDelegate : CheckServerDelegate = new CheckServerDelegate();

        private var _ignoreServerDelegate : IgnoreServerDelegate = new IgnoreServerDelegate();

        private var _abortWorkerDelegate : AbortWorkerDelegate = new AbortWorkerDelegate();

        private var _restartWorkerDelegate : RestartWorkerDelegate = new RestartWorkerDelegate();

        private var _checkWorkerDelegate : CheckWorkerDelegate = new CheckWorkerDelegate();

        private var _ignoreWorkerDelegate : IgnoreWorkerDelegate = new IgnoreWorkerDelegate();

        private var _initializeDelegate : InitializeDelegate = new InitializeDelegate();

        public static function getInstance() : JadortModelLocator {
            if (modelLocator == null) {
                modelLocator = new JadortModelLocator();
            }
            return modelLocator;
        }

        public function JadortModelLocator() {
            super();
            if (JadortModelLocator.modelLocator != null) {
                throw new Error("Only one ModelLocator instance should be instantiated");
            }
        }

        public function get getOperationsListDelegate() : GetOperationsListDelegate {
            return _getOperationsListDelegate;
        }

        public function get deleteOperationDelegate() : DeleteOperationDelegate {
            return _deleteOperationDelegate;
        }

        public function get selectOperationDelegate() : SelectOperationDelegate {
            return _selectOperationDelegate;
        }

        public function get createNewOperationDelegate() : CreateNewOperationDelegate {
            return _createNewOperationDelegate;
        }

        public function get getCurrentOperationDelegate() : GetCurrentOperationDelegate {
            return _getCurrentOperationDelegate;
        }

        public function get getPageIndexDelegate() : GetPageIndexDelegate {
            return _getPageIndexDelegate;
        }

        public function get nextDelegate() : NextDelegate {
            return _nextDelegate;
        }

        public function get previousDelegate() : PreviousDelegate {
            return _previousDelegate;
        }

        public function get loadTopologyDelegate() : LoadTopologyDelegate {
            return _loadTopologyDelegate;
        }

        public function get selectGroupDelegate() : SelectGroupDelegate {
            return _selectGroupDelegate;
        }

        public function get selectServersDelegate() : SelectServersDelegate {
            return _selectServersDelegate;
        }

        public function get selectVMImageDelegate() : SelectVMImageDelegate {
            return _selectVMImageDelegate;
        }

        public function get maintainDelegate() : MaintainDelegate {
            return _maintainDelegate;
        }

        public function get migrateDelegate() : MigrateDelegate {
            return _migrateDelegate;
        }

        public function get selectApplicationDelegate() : SelectApplicationDelegate {
            return _selectApplicationDelegate;
        }

        public function get abortServerDelegate() : AbortServerDelegate {
            return _abortServerDelegate;
        }

        public function get restartServerDelegate() : RestartServerDelegate {
            return _restartServerDelegate;
        }

        public function get checkServerDelegate() : CheckServerDelegate {
            return _checkServerDelegate;
        }

        public function get ignoreServerDelegate() : IgnoreServerDelegate {
            return _ignoreServerDelegate;
        }

        public function get abortWorkerDelegate() : AbortWorkerDelegate {
            return _abortWorkerDelegate;
        }

        public function get restartWorkerDelegate() : RestartWorkerDelegate {
            return _restartWorkerDelegate;
        }

        public function get checkWorkerDelegate() : CheckWorkerDelegate {
            return _checkWorkerDelegate;
        }

        public function get ignoreWorkerDelegate() : IgnoreWorkerDelegate {
            return _ignoreWorkerDelegate;
        }

        public function get initializeDelegate() : InitializeDelegate {
            return _initializeDelegate;
        }
    }
}
