/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ApplicationVO.as 4063 2009-06-18 08:15:08Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.vo {

    import com.adobe.cairngorm.vo.IValueObject;

    [RemoteClass(alias = "org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean")]
    [Bindable]
     public class ApplicationVO implements IValueObject {

        private var applicationName : String;
        private var applicationVersion : String;
        private var applicationState : String;
        private var applicationPolicy : String;

        private var applicationServerName : String;

        public function ApplicationVO() {
            super();
        }

        public function get name() : String {
            return applicationName;
        }

        public function get version() : String {
            return applicationVersion;
        }

        public function get state() : String {
            return applicationState;
        }

        public function get policy() : String {
            return applicationPolicy;
        }

        public function get serverName() : String {
            return applicationServerName;
        }

        public function set name(applicationName : String) : void {
            this.applicationName = applicationName;
        }

        public function set version(applicationVersion : String) : void {
            this.applicationVersion = applicationVersion;
        }

        public function set state(applicationState : String) : void {
            this.applicationState = applicationState;
        }

        public function set policy(applicationPolicy : String) : void {
            this.applicationPolicy = applicationPolicy;
        }

        // Does not exist on the Java side
        public function setServerName(applicationServerName : String) : void {
            this.applicationServerName = applicationServerName;
        }

        public function toString() : String {
            if (version != null && version != "")
                return name + " (version " + version + ")";
            else
                return name;
        }
    }
}
