/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: NextCommand.as 3602 2009-04-30 15:45:25Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.command {
    
    import com.adobe.cairngorm.commands.*;
    import com.adobe.cairngorm.control.*;
    import mx.managers.CursorManager;
    import mx.rpc.IResponder;
    import mx.rpc.events.FaultEvent;
    import mx.rpc.events.ResultEvent;
    import org.ow2.jasmine.jadort.client.flex.business.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.*;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    
    /**
     * This class allows to go to next step, or next task (sub-step)
     */
    public class NextCommand extends SequenceCommandWithErrorHandling implements IResponder{
    
        override public function execute(event : CairngormEvent) : void {
            var model : JadortModelLocator = JadortModelLocator.getInstance();
            model.previousButtonEnabled = false;
            model.nextButtonEnabled = false;

            CursorManager.setBusyCursor();

            // delegate to the NextDelegate to call the next() service
            var delegate : NextDelegate = JadortModelLocator.getInstance().nextDelegate;
            delegate.responder = this;
            delegate.next();
        }

        public function result(event : Object) : void {
            super.nextEvent = new GetCurrentOperationEvent();
            executeNextCommand();
         }
    }
}
