/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SequenceCommandWithErrorHandling.as 4063 2009-06-18 08:15:08Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.jadort.client.flex.command {

    import com.adobe.cairngorm.commands.*;
    import com.adobe.cairngorm.control.*;
    import mx.controls.Alert;
    import mx.managers.CursorManager;
    import mx.messaging.messages.ErrorMessage;
    import mx.rpc.IResponder;
    import mx.rpc.events.FaultEvent;
    import mx.rpc.events.ResultEvent;
    import org.ow2.jasmine.jadort.client.flex.business.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.*;

    public class SequenceCommandWithErrorHandling extends SequenceCommand {
        /**
         * Manage error: show the error message and
         * enable/disable the undo and next buttons.
         */
        public function fault(event : Object) : void {
            CursorManager.removeAllCursors();

            var faultEvent : FaultEvent = FaultEvent(event);
            var errorMessage : ErrorMessage = faultEvent.message as ErrorMessage;
            if (errorMessage.rootCause.info != null) {
                Alert.show(errorMessage.rootCause.info);
            } else {
                Alert.show(errorMessage.rootCause.toString());
            }

            var model : JadortModelLocator = JadortModelLocator.getInstance();
            if (model.currentOperation == null) {
                model.nextButtonEnabled = false;
                model.previousButtonEnabled = false;
                return;
            }

            if (model.index == 7) {
                if (model.selectedServers == null) {
                    model.nextButtonEnabled = false;
                } else {
                    model.nextButtonEnabled = (model.selectedServers.length > 0);
                }
            } else {
                model.nextButtonEnabled = model.currentOperation.canGoToNextStep;
            }
            model.previousButtonEnabled = model.currentOperation.canGoToPreviousStep;
        }
    }
}
