/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkerProgressVO.as 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.vo {

    import com.adobe.cairngorm.vo.IValueObject;
    import mx.controls.Alert;

    [RemoteClass(alias = "org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean")]
    [Bindable]
    public class WorkerProgressVO implements IValueObject {

        private var workerProgressWorker : WorkerVO;
        private var workerProgressState : String;
        private var workerProgressLog : String;
        private var workerProgressProgress : Number;

        public function WorkerProgressVO() {
            super();
        }

        public function get worker() : WorkerVO {
            return workerProgressWorker;
        }

        public function get name() : String {
            return workerProgressWorker.name;
        }

        public function get state() : String {
            return workerProgressState;
        }

        public function get log() : String {
            return workerProgressLog;
        }

        public function get progress() : Number {
            return workerProgressProgress;
        }

        public function set worker(workerProgressWorker : WorkerVO) : void {
            this.workerProgressWorker = workerProgressWorker;
        }

        public function set state(workerProgressState : String) : void {
            this.workerProgressState = workerProgressState;
        }

        public function set log(workerProgressLog : String) : void {
            this.workerProgressLog = workerProgressLog;
        }

        public function set progress(workerProgressProgress : Number) : void {
            this.workerProgressProgress = workerProgressProgress;
        }
    }
}
