/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GetOperationsListCommand.as 3607 2009-05-04 13:44:15Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.command {

    import com.adobe.cairngorm.commands.*;
    import com.adobe.cairngorm.control.*;
    import mx.collections.ArrayCollection;
    import mx.managers.CursorManager;
    import mx.rpc.IResponder;
    import mx.rpc.events.FaultEvent;
    import mx.rpc.events.ResultEvent;
    import org.ow2.jasmine.jadort.client.flex.business.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.*;
    import org.ow2.jasmine.jadort.client.flex.vo.*;

    /**
     * This class allows to get the list of operations
     */
    public class GetOperationsListCommand extends SequenceCommandWithErrorHandling implements IResponder {

        override public function execute(event : CairngormEvent) : void {
            // Set the "busy" cursor
            CursorManager.setBusyCursor();

            // delegate to the GetOperationsListDelegate to call the getOperationsList service
            var delegate : GetOperationsListDelegate = JadortModelLocator.getInstance().getOperationsListDelegate;
            delegate.responder = this;
            delegate.getOperationsList();
        }

        public function result(event : Object) : void {
            CursorManager.removeAllCursors();

            // ArrayCollection value is contained in the event
            var resultEvent : ResultEvent = event as ResultEvent;
            var arrayCollection : ArrayCollection = resultEvent.result as ArrayCollection;

            // Gets the Model
            var model : JadortModelLocator = JadortModelLocator.getInstance();

            // set attributes in the model to update the UI
            model.operationsList = arrayCollection;
        }
    }
}
