/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JadortServiceExceptionWithInfo.java 2507 2008-10-01 16:17:13Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client;

/**
 * This exception class is the one that ActionScript likes, since it uses
 * {@link JadortServiceExceptionWithInfo#getInfo()} and not
 * {@link JadortServiceExceptionWithInfo#getMessage()}.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class JadortServiceExceptionWithInfo extends Exception {

    private static final long serialVersionUID = -6278486776389275380L;

    private String info;

    public JadortServiceExceptionWithInfo(final String info) {
        this.setInfo(info);
    }

    /**
     * Returns this exception's info
     * 
     * @return JaDOrT Information about the exception
     */
    public String getInfo() {
        return this.info;
    }

    /**
     * Sets this exception's info
     * 
     * @param info Information about the exception
     */
    public void setInfo(final String info) {
        this.info = info;
    }
}
