/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.client;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.client.JadortServiceExceptionWithInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadortServiceClient
implements Serializable {
    private static final long serialVersionUID = 3148455079928943579L;
    private IJadortService jadortService;
    private static final Map<OperationStateBean.Step, Integer> Step_PageIndex = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JadortServiceExceptionWithInfo analyzeException(Exception e) {
        Throwable cause;
        for (cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof JadortServiceException) || cause.getMessage() == null) continue;
            return new JadortServiceExceptionWithInfo(cause.getMessage());
        }
        cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        String message = "Container exception " + cause.getClass().getName() + " in the JadortService client: " + cause.getMessage();
        JadortServiceClient jadortServiceClient = this;
        synchronized (jadortServiceClient) {
            System.out.println(message);
            e.printStackTrace();
        }
        return new JadortServiceExceptionWithInfo(message);
    }

    public void initialize() throws JadortServiceExceptionWithInfo {
        try {
            InitialContext context = new InitialContext();
            this.jadortService = (IJadortService)context.lookup("ow2.jasmine.jadort.ServiceSFB");
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public boolean canGoToNextStep() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.canGoToNextStep();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public boolean canGoToPreviousStep() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.canGoToPreviousStep();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public boolean checkServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.checkServer(server);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void createApplication(String urlOrFile) throws JadortServiceExceptionWithInfo {
        try {
            URL url;
            try {
                url = new URL(urlOrFile);
            }
            catch (MalformedURLException e) {
                url = new File(urlOrFile).toURI().toURL();
            }
            this.jadortService.createApplication(url);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public ApplicationBean getApplication() throws JadortServiceExceptionWithInfo {
        try {
            OperationStateBean operation = this.jadortService.getCurrentOperation();
            return operation.getApplication();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void ignoreServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.ignoreServer(server);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public List<ServerProgressBean> getServerProgressList() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getServerProgressList();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public List<WorkerProgressBean> getWorkerProgressList() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getWorkerProgressList();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public List<GroupBean> getGroups() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getGroups();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public int getPageIndex() throws JadortServiceExceptionWithInfo {
        try {
            OperationStateBean operation = this.jadortService.getCurrentOperation();
            return (Integer)Step_PageIndex.get(operation.getCurrentStep());
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public GroupBean getSelectedGroup() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getSelectedGroup();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public int getActiveSessions() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getActiveSessions();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void loadTopology(String xmlTopoFile) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.loadTopology(new File(xmlTopoFile));
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public int next() throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.next();
            return this.getPageIndex();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public int previous() throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.previous();
            return this.getPageIndex();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void restartServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.restartServer(server);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void abortServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.abortServer(server);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void selectGroup(GroupBean selectedGroup, String operationType) throws JadortServiceExceptionWithInfo {
        try {
            GroupBean selectedGroupCopy = new GroupBean();
            selectedGroupCopy.setId(selectedGroup.getId());
            selectedGroupCopy.setName(selectedGroup.getName());
            selectedGroupCopy.setClustered(selectedGroup.getClustered());
            if (operationType.equalsIgnoreCase(IJadortService.OperationType.MIGRATE.toString())) {
                this.jadortService.selectGroup(selectedGroupCopy, IJadortService.OperationType.MIGRATE);
            } else if (operationType.equalsIgnoreCase(IJadortService.OperationType.MAINTAIN.toString())) {
                this.jadortService.selectGroup(selectedGroupCopy, IJadortService.OperationType.MAINTAIN);
            }
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public OperationStateBean createNewOperation(String newOperationName) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.createNewOperation(newOperationName);
            return this.jadortService.getCurrentOperation();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public List<OperationStateBean> getOperationsList() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getOperationsList();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public OperationStateBean selectOperation(OperationStateBean operation) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.selectOperation(operation);
            return this.jadortService.getCurrentOperation();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void deleteOperation(OperationStateBean operation) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.deleteOperation(operation);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void selectServers(List<ServerBean> selectedServers) throws JadortServiceExceptionWithInfo {
        try {
            ArrayList<ServerBean> selectedServersCopy = new ArrayList<ServerBean>(selectedServers);
            this.jadortService.selectServers(selectedServersCopy);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public List<ServerBean> getServers() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getServers();
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void restartWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.restartWorker(worker);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public boolean checkWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.checkWorker(worker);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void abortWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.abortWorker(worker);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    public void ignoreWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.ignoreWorker(worker);
        }
        catch (Exception e) {
            throw this.analyzeException(e);
        }
    }

    static {
        Step_PageIndex.put(OperationStateBean.Step.SELECT_OPERATION, 0);
        Step_PageIndex.put(OperationStateBean.Step.INITIALIZE_TOPOLOGY, 1);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_GROUP, 2);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_APPLICATION, 3);
        Step_PageIndex.put(OperationStateBean.Step.EXECUTING_MIGRATION_PART1, 4);
        Step_PageIndex.put(OperationStateBean.Step.EXECUTING_MIGRATION_PART2, 5);
        Step_PageIndex.put(OperationStateBean.Step.FINISHED, 6);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_SERVERS, 7);
        Step_PageIndex.put(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, 8);
        Step_PageIndex.put(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, 9);
    }
}

