/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.client;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.InvalidStepException;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.client.JadortServiceExceptionWithInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadortServiceClient
implements Serializable {
    private static final long serialVersionUID = 3148455079928943579L;
    private IJadortService jadortService;
    private OperationStateBean operation;
    private static final Map<OperationStateBean.Step, Integer> Step_PageIndex = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeException(Exception e) throws JadortServiceExceptionWithInfo {
        Throwable cause;
        for (cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof JadortServiceExceptionWithInfo)) continue;
            throw (JadortServiceExceptionWithInfo)cause;
        }
        if (this.jadortService == null) {
            throw new JadortServiceExceptionWithInfo("The JaDOrT service has timed out. Please click \"Go to JaDOrT Home\" and resume your operation");
        }
        for (cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof JadortServiceException) || cause.getMessage() == null) continue;
            throw new JadortServiceExceptionWithInfo(cause.getMessage());
        }
        cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        String message = "Container exception " + cause.getClass().getName() + " in the JadortService client: " + cause.getMessage();
        JadortServiceClient jadortServiceClient = this;
        synchronized (jadortServiceClient) {
            System.out.println(message);
            e.printStackTrace();
        }
        throw new JadortServiceExceptionWithInfo(message);
    }

    public void initialize() throws JadortServiceExceptionWithInfo {
        try {
            this.operation = null;
            InitialContext context = new InitialContext();
            this.jadortService = (IJadortService)context.lookup("ow2.jasmine.jadort.ServiceSFB");
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public List<OperationStateBean> getOperationsList() throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.getOperationsList();
        }
        catch (InvalidStepException ise) {
            this.initialize();
            try {
                return this.jadortService.getOperationsList();
            }
            catch (Exception e) {
                this.analyzeException(e);
                return null;
            }
        }
        catch (Exception e) {
            this.analyzeException(e);
            return null;
        }
    }

    public void deleteOperation(OperationStateBean operation) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.deleteOperation(operation);
        }
        catch (InvalidStepException ise) {
            this.initialize();
            try {
                this.jadortService.deleteOperation(operation);
            }
            catch (Exception e) {
                this.analyzeException(e);
            }
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void selectOperation(OperationStateBean operation) throws JadortServiceExceptionWithInfo {
        OperationStateBean selectedOperationCopy = new OperationStateBean();
        selectedOperationCopy.setId(operation.getId());
        selectedOperationCopy.setName(operation.getName());
        try {
            this.jadortService.selectOperation(selectedOperationCopy);
        }
        catch (InvalidStepException ise) {
            this.initialize();
            try {
                this.jadortService.selectOperation(selectedOperationCopy);
            }
            catch (Exception e) {
                this.analyzeException(e);
            }
        }
        catch (Exception e) {
            this.initialize();
            this.analyzeException(e);
        }
    }

    public void createNewOperation(String newOperationName) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.createNewOperation(newOperationName);
        }
        catch (InvalidStepException ise) {
            this.initialize();
            try {
                this.jadortService.createNewOperation(newOperationName);
            }
            catch (Exception e) {
                this.analyzeException(e);
            }
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public OperationStateBean getCurrentOperation() throws JadortServiceExceptionWithInfo {
        try {
            this.operation = this.jadortService.getCurrentOperation();
            return this.operation;
        }
        catch (Exception e) {
            this.analyzeException(e);
            return this.operation;
        }
    }

    public int getPageIndex() throws JadortServiceExceptionWithInfo {
        if (this.operation == null) {
            return (Integer)Step_PageIndex.get(OperationStateBean.Step.SELECT_OPERATION);
        }
        return (Integer)Step_PageIndex.get(this.operation.getCurrentStep());
    }

    public void next() throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.next();
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void previous() throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.previous();
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void loadTopology(String xmlTopoFile) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.loadTopology(new File(xmlTopoFile));
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void selectGroup(GroupBean selectedGroup) throws JadortServiceExceptionWithInfo {
        try {
            GroupBean selectedGroupCopy = new GroupBean();
            selectedGroupCopy.setId(selectedGroup.getId());
            selectedGroupCopy.setName(selectedGroup.getName());
            this.jadortService.selectGroup(selectedGroupCopy);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void migrate() throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.selectOperationType(IJadortService.OperationType.MIGRATE);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void selectApplication(String urlOrFile) throws JadortServiceExceptionWithInfo {
        try {
            URL url;
            try {
                url = new URL(urlOrFile);
            }
            catch (MalformedURLException e) {
                url = new File(urlOrFile).toURI().toURL();
            }
            this.jadortService.selectApplication(url);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void maintain() throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.selectOperationType(IJadortService.OperationType.MAINTAIN);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void selectVMImage(VMImageBean selectedVMImage) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.selectVMImage(selectedVMImage);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void selectServers(List<ServerBean> selectedServers) throws JadortServiceExceptionWithInfo {
        try {
            ArrayList<ServerBean> selectedServersCopy = new ArrayList<ServerBean>(selectedServers.size());
            for (ServerBean server : selectedServers) {
                ServerBean selectedServerCopy = new ServerBean();
                selectedServerCopy.setId(server.getId());
                selectedServerCopy.setName(server.getName());
                selectedServersCopy.add(selectedServerCopy);
            }
            this.jadortService.selectServers(selectedServersCopy);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void selectVMImage(VMImageBean selectedVMImage, ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            ServerBean serverCopy = new ServerBean();
            serverCopy.setId(server.getId());
            serverCopy.setName(server.getName());
            this.jadortService.selectVMImage(selectedVMImage, serverCopy);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void abortServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            ServerBean serverCopy = new ServerBean();
            serverCopy.setId(server.getId());
            serverCopy.setName(server.getName());
            this.jadortService.abortServer(serverCopy);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void restartServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            ServerBean serverCopy = new ServerBean();
            serverCopy.setId(server.getId());
            serverCopy.setName(server.getName());
            this.jadortService.restartServer(serverCopy);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public boolean checkServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            ServerBean serverCopy = new ServerBean();
            serverCopy.setId(server.getId());
            serverCopy.setName(server.getName());
            return this.jadortService.checkServer(serverCopy);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void ignoreServer(ServerBean server) throws JadortServiceExceptionWithInfo {
        try {
            ServerBean serverCopy = new ServerBean();
            serverCopy.setId(server.getId());
            serverCopy.setName(server.getName());
            this.jadortService.ignoreServer(serverCopy);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void abortWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.abortWorker(worker);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public void restartWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.restartWorker(worker);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    public boolean checkWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            return this.jadortService.checkWorker(worker);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void ignoreWorker(WorkerBean worker) throws JadortServiceExceptionWithInfo {
        try {
            this.jadortService.ignoreWorker(worker);
        }
        catch (Exception e) {
            this.analyzeException(e);
        }
    }

    static {
        Step_PageIndex.put(OperationStateBean.Step.SELECT_OPERATION, 0);
        Step_PageIndex.put(OperationStateBean.Step.INITIALIZE_TOPOLOGY, 1);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_GROUP, 2);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_APPLICATION, 3);
        Step_PageIndex.put(OperationStateBean.Step.EXECUTING_MIGRATION, 4);
        Step_PageIndex.put(OperationStateBean.Step.UNDEPLOY_ERASE_OLD_VERSION, 5);
        Step_PageIndex.put(OperationStateBean.Step.FINISHED, 6);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_SERVERS, 7);
        Step_PageIndex.put(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, 8);
        Step_PageIndex.put(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, 9);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_VM_IMAGE, 10);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_OPERATION_TYPE, 11);
        Step_PageIndex.put(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER, 12);
        Step_PageIndex.put(OperationStateBean.Step.DESTROY_OLD_VM_HOSTS, 13);
    }
}

