/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ReadFileServlet.java 6154 2010-03-12 18:08:54Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;

/**
 * A servlet that allows the client to send a file to the server so the server
 * reads it back. This servlet only supports POST, not GET.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class ReadFileServlet extends HttpServlet {

    private static final long serialVersionUID = -6595745152288270603L;

    /**
     * Logger.
     */
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    protected void doPost(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        try {
            ServletOutputStream out = res.getOutputStream();

            try {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator fit = upload.getItemIterator(req);

                while (fit.hasNext()) {
                    FileItemStream fis = fit.next();

                    // Only read non-form fields
                    if (!fis.isFormField()) {
                        InputStream in = fis.openStream();
                        try {
                            IOUtils.copy(in, out);
                            break;
                        } finally {
                            in.close();
                            in = null;
                            System.gc();
                        }
                    }
                }
            } finally {
                out.close();
                out = null;
                System.gc();
            }
        } catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed reading HTTP request", e);
            throw new ServletException(e);
        }
    }
}
