/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.jonas4;

import java.io.File;
import java.net.InetAddress;
import java.util.Set;
import org.objectweb.jasmine.configurator.ConfigurationException;
import org.objectweb.jasmine.configurator.Configurator;
import org.objectweb.jasmine.jade.resource.Resource;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.Logger;
import org.objectweb.jasmine.launcher.LaunchException;
import org.objectweb.jasmine.launcher.Launcher;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.wrapper.jonas4.configurator.JOnASConfigurator;
import org.ow2.jasmine.jade.wrapper.jonas4.launcher.LauncherJonasImpl;

public class JonasRootWrapper
implements GenericAttributeController,
Resource {
    String nodeName;
    String dirLocal;
    static final String[] attList = new String[]{"dirLocal"};
    Launcher launcher;
    Configurator configurator = new JOnASConfigurator();

    public JonasRootWrapper() throws JadeException {
        this.launcher = new LauncherJonasImpl(this.configurator);
        try {
            this.nodeName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new JadeException("cannot read HostName " + e);
        }
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if ("dirLocal".equals(name)) {
            this.dirLocal = value;
            if (!this.dirLocal.endsWith(File.separator)) {
                this.dirLocal = this.dirLocal + File.separator;
            }
        }
        this.configurator.setProperty(name, (Object)value);
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if ("dirLocal".equals(name)) {
            return this.dirLocal;
        }
        Object res = this.configurator.getProperty(name);
        if (res instanceof String) {
            return (String)res;
        }
        return res.toString();
    }

    public String[] listFcAtt() {
        Set<Object> keys = this.configurator.getProperties().keySet();
        return keys.toArray(new String[0]);
    }

    public void configure() throws JadeException {
        Logger.println((boolean)true, (String)"[JonasRootWrapper] configure");
        try {
            this.launcher.configure();
            this.configurator.configure();
        }
        catch (ConfigurationException e) {
            throw new JadeException((Throwable)e);
        }
        catch (LaunchException e) {
            e.printStackTrace();
        }
    }

    public void loadApp() throws JadeException {
        Logger.println((boolean)true, (String)"[JonasRootWrapper] loadApp");
    }

    public void start() throws JadeException {
        Logger.println((boolean)true, (String)"[JonasRootWrapper] start");
        try {
            this.launcher.start();
        }
        catch (LaunchException e) {
            throw new JadeException((Throwable)e);
        }
    }

    public void stop() throws JadeException {
        Logger.println((boolean)true, (String)"[JonasRootWrapper] stop");
        try {
            this.launcher.stop();
        }
        catch (LaunchException e) {
            throw new JadeException((Throwable)e);
        }
    }
}

