/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.jonas4.configurator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.jasmine.configurator.Configurator;
import org.objectweb.jasmine.configurator.statik.velocity.AbstractVelocityCompositeConfigurator;
import org.objectweb.jasmine.configurator.statik.velocity.VelocityConfiguratorImpl;

public class JOnASConfigurator
extends AbstractVelocityCompositeConfigurator {
    Map<String, ConfiguratorProperties> properties = null;
    private static final String PROPS_FILE_NAME = "configurator.properties";
    ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
    private static Logger logger = Logger.getLogger(JOnASConfigurator.class.getName());

    public JOnASConfigurator() {
        try {
            this.parseProperties();
            this.constructCompositeConfigurator();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void constructCompositeConfigurator() {
        Set<String> keys = this.properties.keySet();
        for (String key : keys) {
            ConfiguratorProperties cp = this.properties.get(key);
            if (!cp.isComplete()) continue;
            VelocityConfiguratorImpl vc = new VelocityConfiguratorImpl(this.getContext(), this.cl, cp.getTemplate(), cp.getFile());
            this.addConfigurator(cp.getPrefix(), (Configurator)vc);
            logger.log(Level.INFO, "Configurator " + cp.toString() + " added.");
        }
    }

    private void parseProperties() throws IOException {
        if (this.properties == null) {
            this.properties = new HashMap<String, ConfiguratorProperties>();
        }
        Properties props = new Properties();
        props.load(this.cl.getResourceAsStream(PROPS_FILE_NAME));
        Set<Object> keys = props.keySet();
        for (Object key : keys) {
            StringTokenizer tokenizer = new StringTokenizer(key.toString(), ".");
            if (!tokenizer.hasMoreTokens()) continue;
            String propName = tokenizer.nextToken();
            ConfiguratorProperties cp = this.properties.get(propName);
            if (cp == null) {
                cp = new ConfiguratorProperties();
                this.properties.put(propName, cp);
            }
            if (!tokenizer.hasMoreTokens()) continue;
            String propType = tokenizer.nextToken();
            String propValue = props.getProperty(key.toString());
            if ("template".equals(propType)) {
                cp.setTemplate(propValue);
                continue;
            }
            if ("file".equals(propType)) {
                cp.setFile(propValue);
                continue;
            }
            if (!"prefix".equals(propType)) continue;
            cp.setPrefix(propValue);
        }
    }

    class ConfiguratorProperties {
        private String template;
        private String file;
        private String prefix;

        public ConfiguratorProperties() {
        }

        public ConfiguratorProperties(String template, String file, String prefix) {
            this.template = template;
            this.file = file;
            this.prefix = prefix;
        }

        public boolean isComplete() {
            return !"".equals(this.template) && !"".equals(this.file) && !"".equals(this.prefix) && this.template != null && this.file != null && this.prefix != null;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return "[" + this.prefix + " : " + this.template + " : " + this.file + "]";
        }
    }
}

