/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.jonas4.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.jasmine.configurator.Configurator;
import org.objectweb.jasmine.launcher.DisplayThread;
import org.objectweb.jasmine.launcher.LaunchException;
import org.objectweb.jasmine.launcher.Launcher;

public class LauncherJonasImpl
implements Launcher {
    Configurator configurator;
    JonasThread jonasThread = null;
    private final String SCRIPT_FILE_NAME = "jonas.sh";
    static Logger logger = Logger.getLogger(LauncherJonasImpl.class.getName());
    private Boolean started = false;

    public LauncherJonasImpl(Configurator configurator) {
        this.configurator = configurator;
        logger.setLevel(Level.INFO);
    }

    public void start() throws LaunchException {
        if (this.jonasThread == null) {
            this.jonasThread = new JonasThread();
        }
        this.jonasThread.start();
    }

    public void stop() throws LaunchException {
        System.out.println("Stop JONAS");
        Runtime r = Runtime.getRuntime();
        try {
            String command = new String("sh " + this.getScriptFileName() + " stop");
            Process s = r.exec(command);
            s.waitFor();
            this.setStarted(false);
            if (this.jonasThread != null) {
                this.jonasThread.stopMe();
                this.jonasThread.join();
                this.jonasThread = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void configure() throws LaunchException {
        File jonasbase = new File(this.getJonasBase());
        if (!jonasbase.exists()) {
            try {
                logger.info(jonasbase.getCanonicalFile().toString() + " doesn't exists, so we create it...");
                this.createJonasBase();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createJonasBase() {
        if (this.getJonasRoot() == null) {
            return;
        }
        String command = new String("sh " + this.getScriptFileName() + " base");
        Runtime r = Runtime.getRuntime();
        try {
            String line;
            Process script = r.exec(command);
            script.waitFor();
            InputStream inputstream = script.getInputStream();
            InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
            BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
            while ((line = bufferedreader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeJonasBase() {
        if (this.getJonasBase() == null) {
            return;
        }
        String command = new String("rm -R " + this.getJonasBase());
        Runtime r = Runtime.getRuntime();
        try {
            Process script = r.exec(command);
            script.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean isStarted() {
        return this.started;
    }

    private void setStarted(Boolean started) {
        this.started = started;
    }

    protected void finalize() throws Throwable {
        File f = new File(this.getScriptFileName());
        if (f.exists()) {
            f.delete();
        }
        if (this.isStarted().booleanValue()) {
            this.stop();
        }
        super.finalize();
    }

    private String getInstanceName() {
        return this.configurator.getProperty("instance-jonas-name").toString();
    }

    private String getJonasBase() {
        return this.configurator.getProperty("instance-jonas-base").toString();
    }

    private String getJonasRoot() {
        return this.configurator.getProperty("instance-jonas-root").toString();
    }

    private String getScriptFileName() {
        File file;
        String installDir = this.configurator.getProperty("install-dir").toString();
        if (installDir != null && (file = new File(installDir)).exists() && file.isDirectory()) {
            if (installDir.endsWith(File.separator)) {
                return installDir + "jonas.sh";
            }
            return installDir + File.separator + "jonas.sh";
        }
        return "jonas.sh";
    }

    private class JonasThread
    extends Thread {
        boolean stop = false;
        Process script;
        DisplayThread edt;
        DisplayThread ndt;

        private JonasThread() {
        }

        public void run() {
            if (LauncherJonasImpl.this.getInstanceName() == null || LauncherJonasImpl.this.getJonasBase() == null || LauncherJonasImpl.this.getJonasRoot() == null) {
                return;
            }
            Runtime r = Runtime.getRuntime();
            try {
                String command = new String("sh " + LauncherJonasImpl.this.getScriptFileName() + " start");
                this.script = r.exec(command);
                InputStream inputstream = this.script.getInputStream();
                this.ndt = new DisplayThread(inputstream, LauncherJonasImpl.this.getJonasBase());
                this.ndt.start();
                InputStream errorstream = this.script.getErrorStream();
                this.edt = new DisplayThread(errorstream, LauncherJonasImpl.this.getJonasBase());
                this.edt.start();
                this.script.waitFor();
                LauncherJonasImpl.this.setStarted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void stopMe() {
            this.stop = true;
            if (this.edt != null) {
                this.edt.setStopped(true);
            }
            if (this.ndt != null) {
                this.ndt.setStopped(true);
            }
            if (this.script != null) {
                this.script.destroy();
            }
        }
    }
}

